/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.production.KeyingDataException;
import xades4j.production.SigningCertKeyUsageException;
import xades4j.production.SigningCertValidityException;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.BasicSignatureOptionsProvider;
import xades4j.utils.CanonicalizerUtils;
import xades4j.utils.TransformUtils;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class KeyInfoBuilder {
    private final BasicSignatureOptionsProvider basicSignatureOptionsProvider;
    private final AlgorithmsProviderEx algorithmsProvider;
    private final AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller;

    KeyInfoBuilder(BasicSignatureOptionsProvider basicSignatureOptionsProvider, AlgorithmsProviderEx algorithmsProvider, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller) {
        this.basicSignatureOptionsProvider = basicSignatureOptionsProvider;
        this.algorithmsProvider = algorithmsProvider;
        this.algorithmsParametersMarshaller = algorithmsParametersMarshaller;
    }

    void buildKeyInfo(X509Certificate signingCertificate, XMLSignature xmlSig) throws KeyingDataException, UnsupportedAlgorithmException {
        boolean[] keyUsage = signingCertificate.getKeyUsage();
        if (keyUsage != null && !keyUsage[0] && !keyUsage[1]) {
            throw new SigningCertKeyUsageException(signingCertificate);
        }
        try {
            signingCertificate.checkValidity();
        }
        catch (CertificateException ce) {
            throw new SigningCertValidityException(signingCertificate);
        }
        if (this.basicSignatureOptionsProvider.includeSigningCertificate()) {
            try {
                X509Data x509Data = new X509Data(xmlSig.getDocument());
                x509Data.addCertificate(signingCertificate);
                x509Data.addSubjectName(signingCertificate);
                x509Data.addIssuerSerial(signingCertificate.getIssuerX500Principal().getName(), signingCertificate.getSerialNumber());
                xmlSig.getKeyInfo().add(x509Data);
                if (this.basicSignatureOptionsProvider.signSigningCertificate()) {
                    String keyInfoId = String.valueOf(xmlSig.getId()) + "-keyinfo";
                    xmlSig.getKeyInfo().setId(keyInfoId);
                    Algorithm canonAlg = this.algorithmsProvider.getCanonicalizationAlgorithmForSignature();
                    CanonicalizerUtils.checkC14NAlgorithm(canonAlg);
                    Transforms transforms = TransformUtils.createTransforms(canonAlg, this.algorithmsParametersMarshaller, xmlSig.getDocument());
                    xmlSig.addDocument(String.valueOf('#') + keyInfoId, transforms, this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences());
                }
            }
            catch (XMLSignatureException ex) {
                throw new UnsupportedAlgorithmException("Digest algorithm not supported in the XML Signature provider", this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences(), ex);
            }
            catch (XMLSecurityException ex) {
                throw new KeyingDataException(ex.getMessage(), ex);
            }
        }
        if (this.basicSignatureOptionsProvider.includePublicKey()) {
            xmlSig.addKeyInfo(signingCertificate.getPublicKey());
        }
    }
}

