/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.production.AnonymousDataObjectReference;
import xades4j.production.Enveloped;
import xades4j.production.SignedDataObjects;
import xades4j.production.SignerC;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesCSigningProfile;
import xades4j.providers.ValidationDataProvider;
import xades4j.providers.impl.ValidationDataFromCertValidationProvider;
import xades4j.verification.VerifierTestBase;

public class SignerCTest
extends SignerTestBase {
    @Test
    public void testSignC() throws Exception {
        System.out.println("signC");
        Document doc = SignerCTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        ValidationDataFromCertValidationProvider vdp = new ValidationDataFromCertValidationProvider(VerifierTestBase.validationProviderNist);
        SignerC signer = (SignerC)new XadesCSigningProfile(keyingProviderNist, (ValidationDataProvider)vdp).newSigner();
        new Enveloped(signer).sign(elemToSign);
        SignerCTest.outputDocument(doc, "document.signed.c.xml");
    }

    @Test
    public void testSignFileDetachedC() throws Exception {
        System.out.println("signFileDetachedC");
        ValidationDataFromCertValidationProvider vdp = new ValidationDataFromCertValidationProvider(VerifierTestBase.validationProviderNist);
        SignerC signer = (SignerC)new XadesCSigningProfile(keyingProviderNist, (ValidationDataProvider)vdp).newSigner();
        FileInputStream is = new FileInputStream("license.txt");
        AnonymousDataObjectReference ref = new AnonymousDataObjectReference(is);
        SignedDataObjects objs = new SignedDataObjects(ref);
        Document doc = SignerCTest.getNewDocument();
        signer.sign(objs, doc);
        ((InputStream)is).close();
        SignerCTest.outputDocument(doc, "detached.c.xml");
    }
}

