/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.GenericAlgorithm;
import xades4j.algorithms.XPath2FilterTransform;
import xades4j.algorithms.XPathTransform;
import xades4j.properties.CommitmentTypeProperty;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.utils.SignatureServicesTestBase;

public class DataObjectDescTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWithTransform() throws Exception {
        System.out.println("withTransform");
        Document doc = SignatureServicesTestBase.getNewDocument();
        DataObjectDesc instance = new DataObjectDescTestImpl().withTransform(new XPathTransform("xpath")).withTransform(XPath2FilterTransform.XPath2Filter.subtract("xpath1").intersect("xpath2")).withTransform(new GenericAlgorithm("uri", doc.createElement("param1"), doc.createElement("param2")));
        Algorithm[] transforms = instance.getTransforms().toArray(new Algorithm[0]);
        Assert.assertEquals((long)3L, (long)transforms.length);
        Assert.assertEquals(XPathTransform.class, transforms[0].getClass());
        Assert.assertEquals(XPath2FilterTransform.class, transforms[1].getClass());
        Assert.assertEquals(GenericAlgorithm.class, transforms[2].getClass());
    }

    @Test(expected=IllegalStateException.class)
    public void testWithDataObjectFormatRepeatedInstance() {
        System.out.println("withDataObjectFormatRepeatedInstance");
        DataObjectFormatProperty format = new DataObjectFormatProperty();
        DataObjectDescTestImpl instance = new DataObjectDescTestImpl();
        instance.withDataObjectFormat(format);
        instance.withDataObjectFormat(format);
    }

    public void testWithDataObjectFormatMultipleTargets() {
        System.out.println("withDataObjectFormatMultipleTargets");
        DataObjectFormatProperty format = new DataObjectFormatProperty();
        DataObjectDescTestImpl instance = new DataObjectDescTestImpl();
        DataObjectDescTestImpl other = new DataObjectDescTestImpl();
        other.withDataObjectFormat(format);
        instance.withDataObjectFormat(format);
    }

    @Test
    public void testWithCommitmentType() {
        System.out.println("withCommitmentType");
        CommitmentTypeProperty commitment1 = CommitmentTypeProperty.proofOfApproval();
        CommitmentTypeProperty commitment2 = CommitmentTypeProperty.proofOfCreation();
        DataObjectDescTestImpl instance = new DataObjectDescTestImpl();
        instance.withCommitmentType(commitment1);
        instance.withCommitmentType(commitment2);
    }

    @Test
    public void testHasProperties() {
        System.out.println("hasProperties");
        DataObjectDescTestImpl instance = new DataObjectDescTestImpl();
        Assert.assertEquals((Object)instance.hasProperties(), (Object)false);
        instance.withDataObjectFormat(new DataObjectFormatProperty());
        Assert.assertEquals((Object)instance.hasProperties(), (Object)true);
    }

    @Test
    public void testGetSignedDataObjProps() {
        System.out.println("getSignedDataObjProps");
        DataObjectDescTestImpl instance = new DataObjectDescTestImpl();
        Assert.assertEquals((long)instance.getSignedDataObjProps().size(), (long)0L);
        instance.withDataObjectFormat(new DataObjectFormatProperty());
        Assert.assertEquals((long)instance.getSignedDataObjProps().size(), (long)1L);
    }

    public class DataObjectDescTestImpl
    extends DataObjectDesc {
    }
}

