/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMHelper {
    private DOMHelper() {
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element createElement(Document doc, String name, String prefix, String namespaceURI) {
        if (prefix != null) {
            name = String.valueOf(prefix) + ":" + name;
        }
        return doc.createElementNS(namespaceURI, name);
    }

    public static Element createElementInTempDocument(String name, String prefix, String namespaceURI) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            return DOMHelper.createElement(doc, name, prefix, namespaceURI);
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    public static Element getFirstChildElement(Node node) {
        node = node.getFirstChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getLastChildElement(Node node) {
        node = node.getLastChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getPreviousSibling();
        }
        return (Element)node;
    }

    public static Element getNextSiblingElement(Node node) {
        while ((node = node.getNextSibling()) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    public static Element getFirstDescendant(Element e, String namespaceUri, String localName) {
        return (Element)e.getElementsByTagNameNS(namespaceUri, localName).item(0);
    }

    public static Collection<Element> getChildElementsByTagNameNS(Element e, String namespaceURI, String localName) {
        Node node = e.getFirstChild();
        ArrayList<Element> elements = new ArrayList<Element>();
        while (node != null) {
            if (node.getNodeType() == 1 && namespaceURI.equals(node.getNamespaceURI()) && localName.equals(node.getLocalName())) {
                elements.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return elements;
    }

    public static NodeList nodeList(Iterable<Node> nodes) {
        HelperNodeList nl = new HelperNodeList();
        for (Node n : nodes) {
            nl.appendChild(n);
        }
        return nl;
    }

    public static void setIdAsXmlId(Element e, String id) {
        e.setAttributeNS(null, "Id", id);
        e.setIdAttributeNS(null, "Id", true);
    }

    public static void useIdAsXmlId(Element e) {
        if (e.hasAttributeNS(null, "Id")) {
            e.setIdAttributeNS(null, "Id", true);
        }
    }
}

