/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import xades4j.properties.PropertyTargetException;

public class PropertiesSet<T> {
    private final Map<Class, Set<T>> properties;

    public PropertiesSet(int initialNPropTypes) {
        this.properties = new HashMap<Class, Set<T>>(initialNPropTypes);
    }

    public void put(T prop) {
        if (prop == null) {
            throw new NullPointerException("Property cannot be null");
        }
        if (this.properties.containsKey(prop.getClass())) {
            throw new PropertyTargetException(String.format("A property of type %s was already added", prop.getClass().getSimpleName()));
        }
        this.add(prop);
    }

    public void add(T prop) {
        if (prop == null) {
            throw new NullPointerException("Property cannot be null");
        }
        Set<T> propsOfCurrType = this.properties.get(prop.getClass());
        if (propsOfCurrType == null) {
            propsOfCurrType = new HashSet<T>(1);
            this.properties.put(prop.getClass(), propsOfCurrType);
        }
        if (!propsOfCurrType.add(prop)) {
            throw new PropertyTargetException("Property instance already present");
        }
    }

    public void remove(T prop) {
        if (prop == null) {
            throw new NullPointerException("Property cannot be null");
        }
        Set<T> propsOfCurrType = this.properties.get(prop.getClass());
        if (propsOfCurrType == null || !propsOfCurrType.remove(prop)) {
            throw new IllegalStateException("Property not present");
        }
        if (propsOfCurrType.isEmpty()) {
            this.properties.remove(prop.getClass());
        }
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Collection<T> getProperties() {
        if (this.properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> props = new ArrayList<T>(this.properties.size() + 3);
        for (Set<T> propsOfType : this.properties.values()) {
            props.addAll(propsOfType);
        }
        return props;
    }
}

