/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import xades4j.properties.CompleteCertificateRefsProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.CertRef;
import xades4j.properties.data.CompleteCertificateRefsData;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.verification.CertRefUtils;
import xades4j.verification.CompleteCertRefsCertNotFoundException;
import xades4j.verification.CompleteCertRefsReferenceException;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;

class CompleteCertRefsVerifier
implements QualifyingPropertyVerifier<CompleteCertificateRefsData> {
    private final MessageDigestEngineProvider messageDigestProvider;

    @Inject
    public CompleteCertRefsVerifier(MessageDigestEngineProvider messageDigestProvider) {
        this.messageDigestProvider = messageDigestProvider;
    }

    @Override
    public QualifyingProperty verify(CompleteCertificateRefsData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
        List<X509Certificate> caCerts = ctx.getCertChainData().getCertificateChain();
        caCerts = caCerts.subList(1, caCerts.size());
        Collection<CertRef> caCertRefs = propData.getCertRefs();
        for (X509Certificate caCert : caCerts) {
            CertRef caRef = CertRefUtils.findCertRef(caCert, caCertRefs);
            if (caRef == null) {
                throw new CompleteCertRefsCertNotFoundException(caCert);
            }
            try {
                CertRefUtils.checkCertRef(caRef, caCert, this.messageDigestProvider);
            }
            catch (CertRefUtils.InvalidCertRefException ex) {
                throw new CompleteCertRefsReferenceException(caCert, caRef, ex.getMessage());
            }
        }
        return new CompleteCertificateRefsProperty(Collections.unmodifiableList(caCerts));
    }
}

