/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.GenericDOMData;
import xades4j.verification.GenericDOMDataVerifier;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.TestElemDOMVerifier;

public class GenericDOMDataVerifierTest {
    private static Map<QName, QualifyingPropertyVerifier> customElemVerifiers;
    private static Document testDocument;

    @BeforeClass
    public static void setUpClass() throws Exception {
        customElemVerifiers = new HashMap<QName, QualifyingPropertyVerifier>(1);
        customElemVerifiers.put(new QName("http://test.generic.dom", "Elem"), new TestElemDOMVerifier());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        testDocument = dbf.newDocumentBuilder().newDocument();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testVerify() throws Exception {
        GenericDOMData propData = new GenericDOMData(testDocument.createElementNS("http://test.generic.dom", "Elem"));
        QualifyingPropertyVerificationContext ctx = null;
        GenericDOMDataVerifier instance = new GenericDOMDataVerifier(customElemVerifiers);
        QualifyingProperty result = instance.verify(propData, ctx);
        Assert.assertEquals((Object)result.getName(), (Object)"Elem");
    }

    @Test(expected=InvalidPropertyException.class)
    public void testVerifyNoVerifier() throws Exception {
        GenericDOMData propData = new GenericDOMData(testDocument.createElementNS("http://test.generic.dom", "Elem"));
        QualifyingPropertyVerificationContext ctx = null;
        GenericDOMDataVerifier instance = new GenericDOMDataVerifier(new HashMap<QName, QualifyingPropertyVerifier>(0));
        instance.verify(propData, ctx);
    }
}

