/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.properties.ObjectIdentifier;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.SignaturePolicyDocumentProvider;
import xades4j.providers.impl.PKIXCertificateValidationProvider;
import xades4j.utils.FileSystemDirectoryCertStore;
import xades4j.utils.SignatureServicesTestBase;
import xades4j.verification.SignatureSpecificVerificationOptions;
import xades4j.verification.XAdESForm;
import xades4j.verification.XAdESVerificationResult;
import xades4j.verification.XadesVerificationProfile;

public class VerifierTestBase
extends SignatureServicesTestBase {
    static SignaturePolicyDocumentProvider policyDocumentFinder;
    public static CertificateValidationProvider validationProviderMySigs;
    public static CertificateValidationProvider validationProviderNist;
    public static CertificateValidationProvider validationProviderPtCc;

    static {
        try {
            policyDocumentFinder = new SignaturePolicyDocumentProvider(){

                @Override
                public InputStream getSignaturePolicyDocumentStream(ObjectIdentifier sigPolicyId) {
                    return new ByteArrayInputStream("Test policy input stream".getBytes());
                }
            };
            FileSystemDirectoryCertStore certStore = VerifierTestBase.createDirectoryCertStore("my");
            KeyStore ks = VerifierTestBase.createAndLoadJKSKeyStore("my/myStore", "mystorepass");
            validationProviderMySigs = new PKIXCertificateValidationProvider(ks, false, certStore.getStore());
            certStore = VerifierTestBase.createDirectoryCertStore("csrc.nist");
            FileSystemDirectoryCertStore gvaCRLStore = VerifierTestBase.createDirectoryCertStore("gva");
            ks = VerifierTestBase.createAndLoadJKSKeyStore("csrc.nist/trustAnchor", "password");
            validationProviderNist = new PKIXCertificateValidationProvider(ks, true, certStore.getStore(), gvaCRLStore.getStore());
            certStore = VerifierTestBase.createDirectoryCertStore("pt");
            try {
                ks = KeyStore.getInstance("Windows-ROOT");
                ks.load(null);
                validationProviderPtCc = new PKIXCertificateValidationProvider(ks, false, certStore.getStore());
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            throw new NullPointerException("VerifierTestBase init failed: " + ex.getMessage());
        }
    }

    protected static XAdESForm verifySignature(String sigFileName) throws Exception {
        return VerifierTestBase.verifySignature(sigFileName, new XadesVerificationProfile(validationProviderMySigs), null);
    }

    protected static XAdESForm verifySignature(String sigFileName, XadesVerificationProfile p) throws Exception {
        return VerifierTestBase.verifySignature(sigFileName, p, null);
    }

    protected static XAdESForm verifySignature(String sigFileName, SignatureSpecificVerificationOptions options) throws Exception {
        return VerifierTestBase.verifySignature(sigFileName, new XadesVerificationProfile(validationProviderMySigs), options);
    }

    private static XAdESForm verifySignature(String sigFileName, XadesVerificationProfile p, SignatureSpecificVerificationOptions options) throws Exception {
        Element signatureNode = VerifierTestBase.getSigElement(VerifierTestBase.getDocument(sigFileName));
        XAdESVerificationResult res = p.newVerifier().verify(signatureNode, options);
        return res.getSignatureForm();
    }

    public static Element getSigElement(Document doc) throws Exception {
        return (Element)doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
    }

    protected static KeyStore createAndLoadJKSKeyStore(String path, String pwd) throws Exception {
        path = VerifierTestBase.toPlatformSpecificFilePath("./src/test/cert/" + path);
        FileInputStream fis = new FileInputStream(path);
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(fis, pwd.toCharArray());
        fis.close();
        return ks;
    }

    protected static FileSystemDirectoryCertStore createDirectoryCertStore(String dir) throws CertificateException, CRLException {
        dir = VerifierTestBase.toPlatformSpecificFilePath("./src/test/cert/" + dir);
        return new FileSystemDirectoryCertStore(dir);
    }
}

