/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.CanonicalXMLWithoutComments;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.algorithms.ExclusiveCanonicalXMLWithComments;
import xades4j.algorithms.GenericAlgorithm;
import xades4j.algorithms.XPathTransform;
import xades4j.utils.SignatureServicesTestBase;
import xades4j.xml.marshalling.algorithms.AlgorithmParametersBindingsModule;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProviderImpl;

public class AlgorithmsParametersMarshallingProviderImplTest {
    private Document doc;
    private AlgorithmsParametersMarshallingProviderImpl sut;

    @Before
    public void setUp() throws Exception {
        this.doc = SignatureServicesTestBase.getNewDocument();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AlgorithmParametersBindingsModule()});
        this.sut = new AlgorithmsParametersMarshallingProviderImpl(injector);
    }

    @Test
    public void testMarshalParametersWithDefaultConfiguration() throws Exception {
        List<Node> params;
        Algorithm[] algorithms;
        Algorithm[] algorithmArray = algorithms = new Algorithm[]{new XPathTransform("xpath"), new ExclusiveCanonicalXMLWithComments(new String[]{"ds foo bar"}), new GenericAlgorithm("uri", this.doc.createElement("param1"), this.doc.createElement("param2"))};
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            Algorithm alg = algorithmArray[n2];
            params = this.sut.marshalParameters(alg, this.doc);
            Assert.assertNotNull(params);
            Assert.assertFalse((boolean)params.isEmpty());
            ++n2;
        }
        algorithmArray = algorithms = new Algorithm[]{new EnvelopedSignatureTransform(), new ExclusiveCanonicalXMLWithComments(new String[0]), new CanonicalXMLWithoutComments(), new GenericAlgorithm("uri", new Node[0])};
        n = algorithms.length;
        n2 = 0;
        while (n2 < n) {
            Algorithm t = algorithmArray[n2];
            params = this.sut.marshalParameters(t, this.doc);
            Assert.assertNull(params);
            ++n2;
        }
    }
}

