/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import xades4j.properties.data.CRLRef;
import xades4j.properties.data.CompleteRevocationRefsData;
import xades4j.xml.bind.xades.XmlCRLIdentifierType;
import xades4j.xml.bind.xades.XmlCRLRefType;
import xades4j.xml.bind.xades.XmlCRLRefsType;
import xades4j.xml.bind.xades.XmlCompleteRevocationRefsType;
import xades4j.xml.bind.xades.XmlUnsignedSignaturePropertiesType;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.UnsignedSigPropFromXmlConv;

class FromXmlCompleteRevocRefsConverter
implements UnsignedSigPropFromXmlConv {
    FromXmlCompleteRevocRefsConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlUnsignedSignaturePropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        XmlCompleteRevocationRefsType xmlCompleteRevocRefs = xmlProps.getCompleteRevocationRefs();
        if (xmlCompleteRevocRefs == null) {
            return;
        }
        if (xmlCompleteRevocRefs.getOCSPRefs() != null || xmlCompleteRevocRefs.getOtherRefs() != null) {
            throw new PropertyUnmarshalException("Only CRL references are supported", "CompleteRevocationRefs");
        }
        XmlCRLRefsType xmlCRLRefs = xmlCompleteRevocRefs.getCRLRefs();
        if (xmlCRLRefs == null) {
            throw new PropertyUnmarshalException("CRL references not present", "CompleteRevocationRefs");
        }
        CompleteRevocationRefsData complRevocRefsData = new CompleteRevocationRefsData();
        for (XmlCRLRefType xmlCRLRef : xmlCRLRefs.getCRLRef()) {
            XmlCRLIdentifierType xmlCrlId = xmlCRLRef.getCRLIdentifier();
            complRevocRefsData.addCRLRef(new CRLRef(xmlCrlId.getIssuer(), xmlCrlId.getNumber(), xmlCRLRef.getDigestAlgAndValue().getDigestMethod().getAlgorithm(), xmlCRLRef.getDigestAlgAndValue().getDigestValue(), xmlCrlId.getIssueTime().toGregorianCalendar()));
        }
        propertyDataCollector.setCompleteRevocRefs(complRevocRefsData);
    }
}

