/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import xades4j.production.AnonymousDataObjectReference;
import xades4j.properties.AllDataObjsCommitmentTypeProperty;
import xades4j.properties.AllDataObjsTimeStampProperty;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.OtherSignedDataObjectProperty;
import xades4j.properties.OtherUnsignedDataObjectProperty;
import xades4j.properties.SignedDataObjectProperty;
import xades4j.properties.UnsignedDataObjectProperty;
import xades4j.utils.PropertiesSet;

public final class SignedDataObjects {
    private final List<DataObjectDesc> dataObjs = new ArrayList<DataObjectDesc>();
    private String baseUriForRelativeReferences = null;
    private boolean hasNullURIReference = false;
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(0);
    private final PropertiesSet<SignedDataObjectProperty> signedDataObjsProperties = new PropertiesSet(0);
    private final PropertiesSet<UnsignedDataObjectProperty> unsignedDataObjsProperties = new PropertiesSet(0);

    public SignedDataObjects() {
    }

    public SignedDataObjects(Iterable<DataObjectDesc> dataObjs) {
        this();
        this.withSignedDataObjects(dataObjs);
    }

    public SignedDataObjects(DataObjectDesc ... dataObjs) {
        this();
        int i = 0;
        while (i < dataObjs.length) {
            this.withSignedDataObject(dataObjs[i]);
            ++i;
        }
    }

    public SignedDataObjects withBaseUri(String baseUri) {
        this.baseUriForRelativeReferences = baseUri;
        return this;
    }

    String getBaseUri() {
        return this.baseUriForRelativeReferences;
    }

    public SignedDataObjects withCommitmentType(AllDataObjsCommitmentTypeProperty commitment) {
        return this.addSignedDataObjProp(commitment);
    }

    public SignedDataObjects withDataObjectsTimeStamp() {
        return this.addSignedDataObjProp(new AllDataObjsTimeStampProperty());
    }

    public SignedDataObjects withOtherDataObjectProperty(OtherSignedDataObjectProperty otherSignedDataObjProp) {
        return this.addSignedDataObjProp(otherSignedDataObjProp);
    }

    private SignedDataObjects addSignedDataObjProp(SignedDataObjectProperty prop) {
        this.signedDataObjsProperties.add(prop);
        return this;
    }

    public SignedDataObjects withOtherDataObjectProperty(OtherUnsignedDataObjectProperty otherUnsignedDataObjProp) {
        this.unsignedDataObjsProperties.add(otherUnsignedDataObjProp);
        return this;
    }

    Collection<SignedDataObjectProperty> getSignedDataObjsProperties() {
        return this.signedDataObjsProperties.getProperties();
    }

    Collection<UnsignedDataObjectProperty> getUnsignedDataObjsProperties() {
        return this.unsignedDataObjsProperties.getProperties();
    }

    public SignedDataObjects withSignedDataObjects(Iterable<DataObjectDesc> objsInfo) {
        for (DataObjectDesc obj : objsInfo) {
            this.withSignedDataObject(obj);
        }
        return this;
    }

    public SignedDataObjects withSignedDataObject(DataObjectDesc object) {
        if (object == null) {
            throw new NullPointerException("Signed object description cannot be null");
        }
        if (this.dataObjs.contains(object)) {
            throw new IllegalStateException("Data object description was already added");
        }
        if (object instanceof AnonymousDataObjectReference) {
            if (this.hasNullURIReference) {
                throw new IllegalStateException("An AnonymousDataObjectReference is already present");
            }
            this.hasNullURIReference = true;
        }
        this.dataObjs.add(object);
        return this;
    }

    boolean isEmpty() {
        return this.dataObjs.isEmpty();
    }

    Collection<DataObjectDesc> getDataObjectsDescs() {
        return this.dataObjs;
    }

    public SignedDataObjects withResourceResolver(ResourceResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("Resolver cannot be null");
        }
        this.resourceResolvers.add(resolver);
        return this;
    }

    List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }
}

