/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverAnonymous;
import org.w3c.dom.Document;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.production.AnonymousDataObjectReference;
import xades4j.production.DataObjectReference;
import xades4j.production.EnvelopedXmlObject;
import xades4j.production.SignedDataObjects;
import xades4j.properties.DataObjectDesc;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.utils.TransformUtils;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class SignedDataObjectsProcessor {
    private final AlgorithmsProviderEx algorithmsProvider;
    private final AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller;

    @Inject
    SignedDataObjectsProcessor(AlgorithmsProviderEx algorithmsProvider, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller) {
        this.algorithmsProvider = algorithmsProvider;
        this.algorithmsParametersMarshaller = algorithmsParametersMarshaller;
    }

    Map<DataObjectDesc, Reference> process(SignedDataObjects signedDataObjects, XMLSignature xmlSignature) throws UnsupportedAlgorithmException {
        if (xmlSignature.getSignedInfo().getLength() != 0) {
            throw new IllegalStateException("XMLSignature already contais references");
        }
        for (ResourceResolver resolver : signedDataObjects.getResourceResolvers()) {
            xmlSignature.addResourceResolver(resolver);
        }
        Collection<DataObjectDesc> dataObjsDescs = signedDataObjects.getDataObjectsDescs();
        IdentityHashMap<DataObjectDesc, Reference> referenceMappings = new IdentityHashMap<DataObjectDesc, Reference>(dataObjsDescs.size());
        String digestMethodUri = this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences();
        boolean hasNullURIReference = false;
        try {
            for (DataObjectDesc dataObjDesc : dataObjsDescs) {
                String refType;
                String refUri;
                Transforms transforms = this.processTransforms(dataObjDesc, xmlSignature.getDocument());
                if (dataObjDesc instanceof DataObjectReference) {
                    DataObjectReference dataObjRef = (DataObjectReference)dataObjDesc;
                    refUri = dataObjRef.getUri();
                    refType = dataObjRef.getType();
                } else if (dataObjDesc instanceof EnvelopedXmlObject) {
                    EnvelopedXmlObject envXmlObj = (EnvelopedXmlObject)dataObjDesc;
                    refUri = String.format("%s-object%d", xmlSignature.getId(), xmlSignature.getObjectLength());
                    refType = "http://www.w3.org/2000/09/xmldsig#Object";
                    ObjectContainer xmlObj = new ObjectContainer(xmlSignature.getDocument());
                    xmlObj.setId(refUri);
                    xmlObj.appendChild(envXmlObj.getContent());
                    xmlObj.setMimeType(envXmlObj.getMimeType());
                    xmlObj.setEncoding(envXmlObj.getEncoding());
                    xmlSignature.appendObject(xmlObj);
                    refUri = String.valueOf('#') + refUri;
                } else if (dataObjDesc instanceof AnonymousDataObjectReference) {
                    if (hasNullURIReference) {
                        throw new IllegalStateException("Multiple AnonymousDataObjectReference detected");
                    }
                    hasNullURIReference = true;
                    refType = null;
                    refUri = null;
                    AnonymousDataObjectReference anonymousRef = (AnonymousDataObjectReference)dataObjDesc;
                    xmlSignature.addResourceResolver((ResourceResolverSpi)new ResolverAnonymous(anonymousRef.getDataStream()));
                } else {
                    throw new ClassCastException("Unsupported SignedDataObjectDesc. Must be one of DataObjectReference, EnvelopedXmlObject and AnonymousDataObjectReference");
                }
                xmlSignature.addDocument(refUri, transforms, digestMethodUri, String.format("%s-ref%d", xmlSignature.getId(), referenceMappings.size()), refType);
                Reference ref = xmlSignature.getSignedInfo().item(referenceMappings.size());
                referenceMappings.put(dataObjDesc, ref);
            }
        }
        catch (XMLSignatureException ex) {
            throw new UnsupportedAlgorithmException("Digest algorithm not supported in the XML Signature provider", digestMethodUri, ex);
        }
        catch (XMLSecurityException ex) {
            throw new IllegalStateException(ex);
        }
        return Collections.unmodifiableMap(referenceMappings);
    }

    private Transforms processTransforms(DataObjectDesc dataObjDesc, Document document) throws UnsupportedAlgorithmException {
        Collection<Algorithm> dObjTransfs = dataObjDesc.getTransforms();
        if (dObjTransfs.isEmpty()) {
            return null;
        }
        return TransformUtils.createTransforms(document, this.algorithmsParametersMarshaller, dObjTransfs);
    }
}

