/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.io.File;
import java.security.KeyStoreException;
import org.junit.Assume;
import org.w3c.dom.Document;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.impl.DirectPasswordProvider;
import xades4j.providers.impl.FileSystemKeyStoreKeyingDataProvider;
import xades4j.providers.impl.FirstCertificateSelector;
import xades4j.providers.impl.PKCS11KeyStoreKeyingDataProvider;
import xades4j.utils.SignatureServicesTestBase;

public class SignerTestBase
extends SignatureServicesTestBase {
    protected static KeyingDataProvider keyingProviderMy;
    protected static KeyingDataProvider keyingProviderNist;
    protected static String PTCC_PKCS11_LIB_PATH;

    static {
        PTCC_PKCS11_LIB_PATH = "C:\\Windows\\System32\\pteidpkcs11.dll";
        try {
            keyingProviderMy = SignerTestBase.createFileSystemKeyingDataProvider("pkcs12", "my/LG.pfx", "mykeypass", true);
            keyingProviderNist = SignerTestBase.createFileSystemKeyingDataProvider("pkcs12", "csrc.nist/test4.p12", "password", false);
        }
        catch (KeyStoreException e) {
            throw new NullPointerException("SignerTestBase init failed: " + e.getMessage());
        }
    }

    public static Document getTestDocument() throws Exception {
        return SignerTestBase.getDocument("document.xml");
    }

    protected static FileSystemKeyStoreKeyingDataProvider createFileSystemKeyingDataProvider(String keyStoreType, String keyStorePath, String keyStorePwd, boolean returnFullChain) throws KeyStoreException {
        keyStorePath = SignerTestBase.toPlatformSpecificCertDirFilePath(keyStorePath);
        return new FileSystemKeyStoreKeyingDataProvider(keyStoreType, keyStorePath, new FirstCertificateSelector(), new DirectPasswordProvider(keyStorePwd), new DirectPasswordProvider(keyStorePwd), returnFullChain);
    }

    protected static void assumePtCcPkcs11OnWindows() {
        Assume.assumeTrue((boolean)SignerTestBase.onWindowsPlatform());
        Assume.assumeTrue((boolean)PKCS11KeyStoreKeyingDataProvider.isProviderAvailable());
        Assume.assumeTrue((boolean)new File(PTCC_PKCS11_LIB_PATH).exists());
    }
}

