/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertStore;
import org.junit.Test;
import xades4j.providers.TimeStampTokenDigestException;
import xades4j.providers.TimeStampTokenVerificationException;
import xades4j.providers.impl.DefaultMessageDigestProvider;
import xades4j.providers.impl.DefaultTimeStampVerificationProvider;
import xades4j.providers.impl.PKIXCertificateValidationProvider;
import xades4j.utils.StreamUtils;
import xades4j.verification.VerifierTestBase;

public class DefaultTimeStampVerificationProviderTest
extends VerifierTestBase {
    @Test
    public void testVerifyTokenSucceeds() throws Exception {
        System.out.println("verifyTokenSucceeds");
        byte[] tsDigestInput = "TestDigestInput".getBytes();
        this.doVerifyToken(tsDigestInput, this.getTestToken());
    }

    @Test(expected=TimeStampTokenDigestException.class)
    public void testVerifyTokenFailsWithDifferentDigestInput() throws Exception {
        System.out.println("terifyTokenFailsWithDifferentDigestInput");
        byte[] tsDigestInput = "Invalid".getBytes();
        this.doVerifyToken(tsDigestInput, this.getTestToken());
    }

    @Test(expected=TimeStampTokenVerificationException.class)
    public void testVerifyTokenFailsWithTamperedToken() throws Exception {
        System.out.println("verifyTokenFailsWithTamperedToken");
        byte[] tsDigestInput = "TestDigestInput".getBytes();
        byte[] tsToken = this.getTestToken();
        int i = 0;
        while (i < tsToken.length) {
            if (i % 10 == 1) {
                tsToken[i] = tsToken[i - 1];
            }
            ++i;
        }
        this.doVerifyToken(tsDigestInput, tsToken);
    }

    private byte[] getTestToken() throws Exception {
        String tokenPath = "./src/test/java/" + this.getClass().getPackage().getName().replace('.', '/') + "/tstoken";
        FileInputStream is = new FileInputStream(tokenPath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtils.readWrite(is, bos);
        is.close();
        return bos.toByteArray();
    }

    private void doVerifyToken(byte[] tsDigestInput, byte[] tsToken) throws Exception {
        KeyStore ks = DefaultTimeStampVerificationProviderTest.createAndLoadJKSKeyStore("gva/trustAnchor", "password");
        PKIXCertificateValidationProvider certificateValidationProvider = new PKIXCertificateValidationProvider(ks, false, new CertStore[0]);
        DefaultTimeStampVerificationProvider timeStampVerificationProvider = new DefaultTimeStampVerificationProvider(certificateValidationProvider, new DefaultMessageDigestProvider());
        timeStampVerificationProvider.verifyToken(tsToken, tsDigestInput);
    }
}

