/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import xades4j.providers.ValidationData;
import xades4j.providers.impl.PKIXCertificateValidationProvider;
import xades4j.utils.FileSystemDirectoryCertStore;

public class PKIXCertificateValidationProviderTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testValidateMy() throws Exception {
        System.out.println("validateMy");
        FileSystemDirectoryCertStore certStore = new FileSystemDirectoryCertStore("./src/test/cert/my");
        KeyStore ks = KeyStore.getInstance("jks");
        FileInputStream fis = new FileInputStream("./src/test/cert/my/myStore");
        ks.load(fis, "mystorepass".toCharArray());
        fis.close();
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setSubject(new X500Principal("CN = Luis Goncalves,OU = CC,O = ISEL,C = PT"));
        List<X509Certificate> otherCerts = Collections.emptyList();
        PKIXCertificateValidationProvider instance = new PKIXCertificateValidationProvider(ks, false, certStore.getStore());
        ValidationData result = instance.validate(certSelector, new Date(), otherCerts);
        Assert.assertEquals((long)result.getCerts().size(), (long)3L);
    }

    @Test
    public void testValidateNist() throws Exception {
        System.out.println("validateNist");
        FileSystemDirectoryCertStore certStore = new FileSystemDirectoryCertStore("./src/test/cert/csrc.nist");
        KeyStore ks = KeyStore.getInstance("jks");
        FileInputStream fis = new FileInputStream("./src/test/cert/csrc.nist/trustAnchor");
        ks.load(fis, "password".toCharArray());
        fis.close();
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setSubject(new X500Principal("CN = User1-CP.02.01,OU = Testing,OU = DoD,O = U.S. Government,C = US"));
        List<X509Certificate> otherCerts = Collections.emptyList();
        PKIXCertificateValidationProvider instance = new PKIXCertificateValidationProvider(ks, true, certStore.getStore());
        ValidationData result = instance.validate(certSelector, new Date(), otherCerts);
        Assert.assertEquals((long)result.getCerts().size(), (long)4L);
        Assert.assertEquals((long)result.getCrls().size(), (long)3L);
    }
}

