/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import xades4j.utils.CollectionUtils;
import xades4j.utils.DataGetter;

public class DataGetterImpl<T>
implements DataGetter<T> {
    private final Collection<T> all;
    private final Map<Class, Set<T>> allByType;

    public DataGetterImpl(Collection<T> all) {
        this.all = Collections.unmodifiableCollection(all);
        this.allByType = this.getAllByType(all);
    }

    private Map<Class, Set<T>> getAllByType(Collection<T> all) {
        HashMap<Class, Set<T>> res = new HashMap<Class, Set<T>>();
        for (T e : all) {
            HashSet<T> typeTs = (HashSet<T>)res.get(e.getClass());
            if (typeTs == null) {
                typeTs = new HashSet<T>();
                res.put(e.getClass(), typeTs);
            }
            typeTs.add(e);
        }
        return res;
    }

    @Override
    public Collection<T> getAll() {
        return this.all;
    }

    @Override
    public <TP extends T> Collection<TP> getOfType(Class<TP> clazz) {
        return CollectionUtils.emptyIfNull((Collection)this.allByType.get(clazz));
    }

    @Override
    public Collection<T> getFiltered(CollectionUtils.Predicate<T> filter) {
        return CollectionUtils.filter(this.all, filter);
    }
}

