/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.utils.DOMHelper;

public class SignatureServicesTestBase {
    private static DocumentBuilder db;

    static {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new NullPointerException("SignatureServicesTestBase init failed:" + ex.getMessage());
        }
    }

    public static String toPlatformSpecificFilePath(String path) {
        return path.replace('/', File.separatorChar);
    }

    public static String toPlatformSpecificXMLDirFilePath(String fileName) {
        return SignatureServicesTestBase.toPlatformSpecificFilePath("./src/test/xml/" + fileName);
    }

    public static String toPlatformSpecificCertDirFilePath(String fileName) {
        return SignatureServicesTestBase.toPlatformSpecificFilePath("./src/test/cert/" + fileName);
    }

    public static boolean onWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static Document getDocument(String fileName) throws Exception {
        String path = SignatureServicesTestBase.toPlatformSpecificXMLDirFilePath(fileName);
        Document doc = db.parse(new FileInputStream(path));
        Element elem = doc.getDocumentElement();
        DOMHelper.useIdAsXmlId(elem);
        return doc;
    }

    public static Document getNewDocument() throws Exception {
        return db.newDocument();
    }

    protected static void outputDocument(Document doc, String fileName) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        File outDir = SignatureServicesTestBase.ensureOutputDir();
        FileOutputStream out = new FileOutputStream(new File(outDir, fileName));
        tf.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        out.close();
    }

    private static File ensureOutputDir() {
        File dir = new File(SignatureServicesTestBase.toPlatformSpecificFilePath("./target/out/"));
        dir.mkdir();
        return dir;
    }
}

