/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.lang.reflect.Type;
import org.junit.Assert;
import org.junit.Test;
import xades4j.utils.A;
import xades4j.utils.AImpl1;
import xades4j.utils.AImpl2;
import xades4j.utils.Action;
import xades4j.utils.ActionOfA;
import xades4j.utils.B;
import xades4j.utils.BImpl;
import xades4j.utils.C;
import xades4j.utils.D;
import xades4j.utils.E;
import xades4j.utils.XadesProfileCore;
import xades4j.utils.XadesProfileResolutionException;

public class XadesProfileCoreTest {
    @Test
    public void testGetInstance() throws XadesProfileResolutionException {
        System.out.println("getInstance");
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(A.class).to(AImpl1.class);
            }
        };
        XadesProfileCore instance = new XadesProfileCore();
        A a = instance.getInstance(A.class, new Module[]{module}, new Module[0]);
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a instanceof AImpl1));
    }

    @Test(expected=XadesProfileResolutionException.class)
    public void testGetInstanceException() throws XadesProfileResolutionException {
        System.out.println("getInstance_Exception");
        XadesProfileCore instance = new XadesProfileCore();
        instance.getInstance(A.class, new Module[0], new Module[0]);
    }

    @Test
    public void testAddBinding() throws XadesProfileResolutionException {
        System.out.println("addBinding");
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bind(A.class).to(AImpl1.class);
            }
        };
        XadesProfileCore instance = new XadesProfileCore();
        instance.addBinding(A.class, AImpl2.class);
        A a = instance.getInstance(A.class, new Module[]{module}, new Module[0]);
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a instanceof AImpl2));
        BImpl b1 = new BImpl();
        instance.addBinding(B.class, b1);
        B b2 = instance.getInstance(B.class, new Module[]{module}, new Module[0]);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void testAddGenericBinding() throws XadesProfileResolutionException {
        System.out.println("addGenericBinding");
        XadesProfileCore instance = new XadesProfileCore();
        instance.addGenericBinding((Type)((Object)Action.class), ActionOfA.class, new Type[]{A.class});
        C c = instance.getInstance(C.class, new Module[0], new Module[0]);
        Assert.assertTrue((boolean)(c.action instanceof ActionOfA));
    }

    @Test
    public void testAddMultibinding() throws Exception {
        System.out.println("addMultibinding");
        XadesProfileCore instance = new XadesProfileCore();
        instance.addMultibinding(A.class, AImpl1.class);
        instance.addMultibinding(A.class, new AImpl1());
        instance.addMultibinding(A.class, AImpl2.class);
        D d = instance.getInstance(D.class, new Module[0], new Module[0]);
        Assert.assertEquals((long)3L, (long)d.as.size());
    }

    @Test
    public void testAddMapBinding() throws Exception {
        System.out.println("addMapBinding");
        XadesProfileCore instance = new XadesProfileCore();
        instance.addMapBinding(A.class, (Object)"A1", AImpl1.class);
        instance.addMapBinding(A.class, (Object)"A2", AImpl2.class);
        E e = instance.getInstance(E.class, new Module[0], new Module[0]);
        Assert.assertEquals((long)2L, (long)e.as.size());
        Assert.assertEquals(AImpl1.class, e.as.get("A1").getClass());
        Assert.assertEquals(AImpl2.class, e.as.get("A2").getClass());
    }
}

