/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Module;
import java.lang.reflect.Type;
import javax.xml.namespace.QName;
import xades4j.properties.data.CustomPropertiesDataObjsStructureVerifier;
import xades4j.properties.data.PropertyDataObject;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.SignaturePolicyDocumentProvider;
import xades4j.providers.TimeStampVerificationProvider;
import xades4j.utils.UtilsBindingsModule;
import xades4j.utils.XadesProfileCore;
import xades4j.utils.XadesProfileResolutionException;
import xades4j.verification.CustomSignatureVerifier;
import xades4j.verification.DefaultVerificationBindingsModule;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.RawSignatureVerifier;
import xades4j.verification.XadesVerifier;
import xades4j.verification.XadesVerifierImpl;
import xades4j.xml.marshalling.algorithms.AlgorithmParametersBindingsModule;
import xades4j.xml.unmarshalling.QualifyingPropertiesUnmarshaller;
import xades4j.xml.unmarshalling.UnmarshallingBindingsModule;

public final class XadesVerificationProfile {
    private final XadesProfileCore profileCore = new XadesProfileCore();
    private boolean acceptUnknownProperties = false;
    private boolean secureValidation = false;
    private static final Module[] overridableModules = new Module[]{new DefaultVerificationBindingsModule(), new UnmarshallingBindingsModule()};
    private static final Module[] sealedModules = new Module[]{new UtilsBindingsModule(), new AlgorithmParametersBindingsModule()};

    private XadesVerificationProfile() {
        this.withBinding((Class)XadesVerifier.class, (Object)XadesVerifierImpl.class);
    }

    public XadesVerificationProfile(CertificateValidationProvider certificateValidationProvider) {
        this();
        this.withBinding(CertificateValidationProvider.class, certificateValidationProvider);
    }

    public XadesVerificationProfile(Class<? extends CertificateValidationProvider> certificateValidationProviderClass) {
        this();
        this.withBinding((Class)CertificateValidationProvider.class, (Object)certificateValidationProviderClass);
    }

    public <T> XadesVerificationProfile withBinding(Class<T> from, Class<? extends T> to) {
        this.profileCore.addBinding(from, to);
        return this;
    }

    public <T> XadesVerificationProfile withBinding(Class<T> from, T to) {
        this.profileCore.addBinding(from, to);
        return this;
    }

    public final XadesVerifier newVerifier() throws XadesProfileResolutionException {
        XadesVerifierImpl v = this.profileCore.getInstance(XadesVerifierImpl.class, overridableModules, sealedModules);
        v.setAcceptUnknownProperties(this.acceptUnknownProperties);
        v.setSecureValidation(this.secureValidation);
        return v;
    }

    public XadesVerificationProfile withDigestEngineProvider(MessageDigestEngineProvider digestProvider) {
        return this.withBinding(MessageDigestEngineProvider.class, digestProvider);
    }

    public XadesVerificationProfile withDigestEngineProvider(Class<? extends MessageDigestEngineProvider> digestProviderClass) {
        return this.withBinding((Class)MessageDigestEngineProvider.class, (Object)digestProviderClass);
    }

    public XadesVerificationProfile withPolicyDocumentProvider(SignaturePolicyDocumentProvider policyDocProvider) {
        return this.withBinding(SignaturePolicyDocumentProvider.class, policyDocProvider);
    }

    public XadesVerificationProfile withPolicyDocumentProvider(Class<? extends SignaturePolicyDocumentProvider> policyDocProviderClass) {
        return this.withBinding((Class)SignaturePolicyDocumentProvider.class, (Object)policyDocProviderClass);
    }

    public XadesVerificationProfile withTimeStampTokenVerifier(TimeStampVerificationProvider tsTokenVerifProv) {
        return this.withBinding(TimeStampVerificationProvider.class, tsTokenVerifProv);
    }

    public XadesVerificationProfile withTimeStampTokenVerifier(Class<? extends TimeStampVerificationProvider> tsTokenVerifProvClass) {
        return this.withBinding((Class)TimeStampVerificationProvider.class, (Object)tsTokenVerifProvClass);
    }

    public XadesVerificationProfile withPropertiesUnmarshaller(QualifyingPropertiesUnmarshaller propsUnmarshaller) {
        return this.withBinding(QualifyingPropertiesUnmarshaller.class, propsUnmarshaller);
    }

    public XadesVerificationProfile withPropertiesUnmarshaller(Class<? extends QualifyingPropertiesUnmarshaller> propsUnmarshallerClass) {
        return this.withBinding((Class)QualifyingPropertiesUnmarshaller.class, (Object)propsUnmarshallerClass);
    }

    public XadesVerificationProfile acceptUnknownProperties(boolean accept) {
        this.acceptUnknownProperties = accept;
        return this;
    }

    public XadesVerificationProfile withSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
        return this;
    }

    public XadesVerificationProfile withGlobalDataObjsStructureVerifier(CustomPropertiesDataObjsStructureVerifier v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(CustomPropertiesDataObjsStructureVerifier.class, v);
        return this;
    }

    public XadesVerificationProfile withGlobalDataObjsStructureVerifier(Class<? extends CustomPropertiesDataObjsStructureVerifier> customVerifierClass) {
        if (customVerifierClass == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(CustomPropertiesDataObjsStructureVerifier.class, customVerifierClass);
        return this;
    }

    public XadesVerificationProfile withRawSignatureVerifier(RawSignatureVerifier v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(RawSignatureVerifier.class, v);
        return this;
    }

    public XadesVerificationProfile withRawSignatureVerifier(Class<? extends RawSignatureVerifier> rawVerifierClass) {
        if (rawVerifierClass == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(RawSignatureVerifier.class, rawVerifierClass);
        return this;
    }

    public XadesVerificationProfile withCustomSignatureVerifier(CustomSignatureVerifier v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(CustomSignatureVerifier.class, v);
        return this;
    }

    public XadesVerificationProfile withCustomSignatureVerifier(Class<? extends CustomSignatureVerifier> customVerifierClass) {
        if (customVerifierClass == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMultibinding(CustomSignatureVerifier.class, customVerifierClass);
        return this;
    }

    public XadesVerificationProfile withElementVerifier(QName elemName, Class<? extends QualifyingPropertyVerifier> vClass) {
        if (elemName == null || vClass == null) {
            throw new NullPointerException();
        }
        this.profileCore.addMapBinding(QualifyingPropertyVerifier.class, (Object)elemName, vClass);
        return this;
    }

    public <TData extends PropertyDataObject> XadesVerificationProfile withQualifyingPropertyVerifier(Class<TData> propDataClass, Class<? extends QualifyingPropertyVerifier<TData>> verifierClass) {
        this.profileCore.addGenericBinding((Type)((Object)QualifyingPropertyVerifier.class), verifierClass, propDataClass);
        return this;
    }

    public <TData extends PropertyDataObject> XadesVerificationProfile withQualifyingPropertyVerifier(Class<TData> propDataClass, QualifyingPropertyVerifier<TData> verifier) {
        this.profileCore.addGenericBinding((Type)((Object)QualifyingPropertyVerifier.class), verifier, propDataClass);
        return this;
    }
}

