/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.io.InputStream;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverAnonymous;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import xades4j.XAdES4jException;
import xades4j.XAdES4jXMLSigException;
import xades4j.production.XadesSignatureFormatExtender;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignatureTimeStampProperty;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.SignatureTimeStampData;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.ValidationData;
import xades4j.utils.CollectionUtils;
import xades4j.utils.ObjectUtils;
import xades4j.utils.PropertiesUtils;
import xades4j.verification.CustomSignatureVerifier;
import xades4j.verification.InvalidFormExtensionException;
import xades4j.verification.InvalidSignatureException;
import xades4j.verification.PropertyInfo;
import xades4j.verification.QualifPropsDataCollectorImpl;
import xades4j.verification.QualifyingPropertiesIncorporationException;
import xades4j.verification.QualifyingPropertiesVerifier;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.RawDataObjectDesc;
import xades4j.verification.RawSignatureVerifier;
import xades4j.verification.ReferenceValueException;
import xades4j.verification.SignatureSpecificVerificationOptions;
import xades4j.verification.SignatureUtils;
import xades4j.verification.SignatureValueException;
import xades4j.verification.XAdESForm;
import xades4j.verification.XAdESFormChecker;
import xades4j.verification.XAdESVerificationResult;
import xades4j.verification.XadesVerifier;
import xades4j.xml.unmarshalling.QualifyingPropertiesUnmarshaller;
import xades4j.xml.unmarshalling.UnmarshalException;

class XadesVerifierImpl
implements XadesVerifier {
    private final CertificateValidationProvider certificateValidator;
    private final QualifyingPropertiesVerifier qualifyingPropertiesVerifier;
    private final QualifyingPropertiesUnmarshaller qualifPropsUnmarshaller;
    private final Set<RawSignatureVerifier> rawSigVerifiers;
    private final Set<CustomSignatureVerifier> customSigVerifiers;
    private boolean secureValidation;
    private static FormExtensionPropsCollector[][] formsExtensionTransitions;

    static {
        Init.init();
        XadesVerifierImpl.initFormExtension();
    }

    @Inject
    protected XadesVerifierImpl(CertificateValidationProvider certificateValidator, QualifyingPropertiesVerifier qualifyingPropertiesVerifier, QualifyingPropertiesUnmarshaller qualifPropsUnmarshaller, Set<RawSignatureVerifier> rawSigVerifiers, Set<CustomSignatureVerifier> customSigVerifiers) {
        if (ObjectUtils.anyNull(certificateValidator, qualifyingPropertiesVerifier, qualifPropsUnmarshaller, rawSigVerifiers, customSigVerifiers)) {
            throw new NullPointerException("One or more arguments are null");
        }
        this.certificateValidator = certificateValidator;
        this.qualifyingPropertiesVerifier = qualifyingPropertiesVerifier;
        this.qualifPropsUnmarshaller = qualifPropsUnmarshaller;
        this.rawSigVerifiers = rawSigVerifiers;
        this.customSigVerifiers = customSigVerifiers;
        this.secureValidation = false;
    }

    void setAcceptUnknownProperties(boolean accept) {
        this.qualifPropsUnmarshaller.setAcceptUnknownProperties(accept);
    }

    void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    @Override
    public XAdESVerificationResult verify(Element signatureElem, SignatureSpecificVerificationOptions verificationOptions) throws XAdES4jException {
        XMLSignature signature;
        if (signatureElem == null) {
            throw new NullPointerException("Signature node not specified");
        }
        if (verificationOptions == null) {
            verificationOptions = SignatureSpecificVerificationOptions.empty;
        }
        try {
            signature = new XMLSignature(signatureElem, verificationOptions.getBaseUri(), this.secureValidation);
        }
        catch (XMLSecurityException ex) {
            throw new UnmarshalException("Bad XML signature", ex);
        }
        String signatureId = signature.getId();
        if (signatureId == null) {
            throw new UnmarshalException("XML signature doesn't have an Id");
        }
        SignatureUtils.ReferencesRes referencesRes = SignatureUtils.processReferences(signature);
        RawSignatureVerifier.RawSignatureVerifierContext rawCtx = new RawSignatureVerifier.RawSignatureVerifierContext(signature);
        for (RawSignatureVerifier rawSignatureVerifier : this.rawSigVerifiers) {
            rawSignatureVerifier.verify(rawCtx);
        }
        Element qualifyingPropsElem = SignatureUtils.getQualifyingPropertiesElement(signature);
        SignatureUtils.checkSignedPropertiesIncorporation(qualifyingPropsElem, referencesRes.signedPropsReference);
        Attr targetAttr = qualifyingPropsElem.getAttributeNodeNS(null, "Target");
        if (targetAttr == null && (targetAttr = qualifyingPropsElem.getAttributeNodeNS("http://uri.etsi.org/01903/v1.3.2#", "Target")) == null) {
            throw new QualifyingPropertiesIncorporationException("QualifyingProperties Target attribute not present");
        }
        String targetValue = targetAttr.getNodeValue();
        if (targetValue == null || !targetValue.startsWith("#") || !targetValue.substring(1).equals(signatureId)) {
            throw new QualifyingPropertiesIncorporationException("QualifyingProperties target doesn't match the signature's Id");
        }
        QualifPropsDataCollectorImpl propsDataCollector = new QualifPropsDataCollectorImpl();
        this.qualifPropsUnmarshaller.unmarshalProperties(qualifyingPropsElem, propsDataCollector);
        Collection<PropertyDataObject> qualifPropsData = propsDataCollector.getPropertiesData();
        SignatureUtils.KeyInfoRes keyInfoRes = SignatureUtils.processKeyInfo(signature.getKeyInfo());
        Date validationDate = this.getValidationDate(qualifPropsData, signature, verificationOptions);
        ValidationData certValidationRes = this.certificateValidator.validate(keyInfoRes.certSelector, validationDate, keyInfoRes.keyInfoCerts);
        if (certValidationRes == null || certValidationRes.getCerts().isEmpty()) {
            throw new NullPointerException("Certificate validator returned null or empty data");
        }
        X509Certificate validationCert = certValidationRes.getCerts().get(0);
        XadesVerifierImpl.doCoreVerification(signature, verificationOptions, validationCert);
        QualifyingPropertyVerificationContext qPropsCtx = new QualifyingPropertyVerificationContext(signature, new QualifyingPropertyVerificationContext.CertificationChainData(certValidationRes.getCerts(), certValidationRes.getCrls(), keyInfoRes.issuerSerial), new QualifyingPropertyVerificationContext.SignedObjectsData(referencesRes.dataObjsReferences, signature));
        Collection<PropertyInfo> props = this.qualifyingPropertiesVerifier.verifyProperties(qualifPropsData, qPropsCtx);
        XAdESVerificationResult res = new XAdESVerificationResult(XAdESFormChecker.checkForm(props), signature, certValidationRes, props, referencesRes.dataObjsReferences);
        for (CustomSignatureVerifier customVer : this.customSigVerifiers) {
            customVer.verify(res, qPropsCtx);
        }
        return res;
    }

    private Date getValidationDate(Collection<PropertyDataObject> qualifPropsData, XMLSignature signature, SignatureSpecificVerificationOptions verificationOptions) throws XAdES4jException {
        List<PropertyDataObject> sigTsData = CollectionUtils.filterByType(qualifPropsData, SignatureTimeStampData.class);
        if (sigTsData.isEmpty()) {
            return verificationOptions.getDefaultVerificationDate();
        }
        QualifyingPropertyVerificationContext ctx = new QualifyingPropertyVerificationContext(signature, new QualifyingPropertyVerificationContext.CertificationChainData(new ArrayList<X509Certificate>(0), new ArrayList<X509CRL>(0), null), new QualifyingPropertyVerificationContext.SignedObjectsData(new ArrayList<RawDataObjectDesc>(0), signature));
        Collection<PropertyInfo> props = this.qualifyingPropertiesVerifier.verifyProperties(sigTsData, ctx);
        QualifyingProperty sigTs = props.iterator().next().getProperty();
        return ((SignatureTimeStampProperty)sigTs).getTime();
    }

    private static void doCoreVerification(XMLSignature signature, SignatureSpecificVerificationOptions verificationOptions, X509Certificate validationCert) throws XAdES4jXMLSigException, InvalidSignatureException {
        InputStream nullURIReferenceData;
        List<ResourceResolver> resolvers = verificationOptions.getResolvers();
        if (!CollectionUtils.nullOrEmpty(resolvers)) {
            for (ResourceResolver resolver : resolvers) {
                signature.addResourceResolver(resolver);
            }
        }
        if ((nullURIReferenceData = verificationOptions.getDataForAnonymousReference()) != null) {
            signature.addResourceResolver((ResourceResolverSpi)new ResolverAnonymous(nullURIReferenceData));
        }
        try {
            if (signature.checkSignatureValue(validationCert)) {
                return;
            }
        }
        catch (XMLSignatureException ex) {
            throw new XAdES4jXMLSigException("Error verifying the signature", ex);
        }
        try {
            if (signature.getSignedInfo().verifyReferences()) {
                throw new SignatureValueException(signature);
            }
            SignedInfo si = signature.getSignedInfo();
            int i = 0;
            while (i < si.getLength()) {
                Reference r = si.item(i);
                if (!r.verify()) {
                    throw new ReferenceValueException(signature, r);
                }
                ++i;
            }
        }
        catch (XMLSecurityException ex) {
            throw new XAdES4jXMLSigException("Error verifying the references", ex);
        }
    }

    private static void initFormExtension() {
        FormExtensionPropsCollector xlAndXPropsCol;
        FormExtensionPropsCollector xPropsCol;
        FormExtensionPropsCollector cPropsCol;
        FormExtensionPropsCollector cAndTPropsCol;
        FormExtensionPropsCollector tPropsCol;
        XAdESForm[] forms = XAdESForm.values();
        formsExtensionTransitions = new FormExtensionPropsCollector[forms.length][forms.length];
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.BES.ordinal()][XAdESForm.T.ordinal()] = tPropsCol = new FormExtensionPropsCollector(){

            @Override
            public void addProps(Collection<UnsignedSignatureProperty> usp, XAdESVerificationResult res) {
                PropertiesUtils.addXadesTProperties(usp);
            }
        };
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.EPES.ordinal()][XAdESForm.T.ordinal()] = tPropsCol;
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.BES.ordinal()][XAdESForm.C.ordinal()] = cAndTPropsCol = new FormExtensionPropsCollector(){

            @Override
            public void addProps(Collection<UnsignedSignatureProperty> usp, XAdESVerificationResult res) {
                PropertiesUtils.addXadesCProperties(usp, res.getValidationData());
                PropertiesUtils.addXadesTProperties(usp);
            }
        };
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.EPES.ordinal()][XAdESForm.C.ordinal()] = cAndTPropsCol;
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.T.ordinal()][XAdESForm.C.ordinal()] = cPropsCol = new FormExtensionPropsCollector(){

            @Override
            public void addProps(Collection<UnsignedSignatureProperty> usp, XAdESVerificationResult res) {
                PropertiesUtils.addXadesCProperties(usp, res.getValidationData());
            }
        };
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.C.ordinal()][XAdESForm.X.ordinal()] = xPropsCol = new FormExtensionPropsCollector(){

            @Override
            public void addProps(Collection<UnsignedSignatureProperty> usp, XAdESVerificationResult res) {
                PropertiesUtils.addXadesXProperties(usp);
            }
        };
        XadesVerifierImpl.formsExtensionTransitions[XAdESForm.C.ordinal()][XAdESForm.X_L.ordinal()] = xlAndXPropsCol = new FormExtensionPropsCollector(){

            @Override
            public void addProps(Collection<UnsignedSignatureProperty> usp, XAdESVerificationResult res) {
                PropertiesUtils.addXadesXLProperties(usp, res.getValidationData());
                PropertiesUtils.addXadesXProperties(usp);
            }
        };
    }

    @Override
    public XAdESVerificationResult verify(Element signatureElem, SignatureSpecificVerificationOptions verificationOptions, XadesSignatureFormatExtender formatExtender, XAdESForm finalForm) throws XAdES4jException {
        if (finalForm == null || formatExtender == null) {
            throw new NullPointerException("'finalForm' and 'formatExtender' cannot be null");
        }
        if (finalForm.before(XAdESForm.T) || finalForm.after(XAdESForm.X_L)) {
            throw new IllegalArgumentException("Signature format can only be extended to XAdES-T, C, X or X-L");
        }
        XAdESVerificationResult res = this.verify(signatureElem, verificationOptions);
        XAdESForm actualForm = res.getSignatureForm();
        if (actualForm.before(finalForm)) {
            FormExtensionPropsCollector finalFormPropsColector = formsExtensionTransitions[actualForm.ordinal()][finalForm.ordinal()];
            if (finalFormPropsColector == null) {
                throw new InvalidFormExtensionException(actualForm, finalForm);
            }
            ArrayList<UnsignedSignatureProperty> usp = new ArrayList<UnsignedSignatureProperty>(3);
            finalFormPropsColector.addProps(usp, res);
            formatExtender.enrichSignature(res.getXmlSignature(), new UnsignedProperties(usp));
        }
        return res;
    }

    private static interface FormExtensionPropsCollector {
        public void addProps(Collection<UnsignedSignatureProperty> var1, XAdESVerificationResult var2);
    }
}

