/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xades4j.production.XadesFormatExtenderProfile;
import xades4j.production.XadesSignatureFormatExtender;
import xades4j.providers.CannotBuildCertificationPathException;
import xades4j.verification.InvalidSignatureException;
import xades4j.verification.RawSignatureVerifier;
import xades4j.verification.SignatureSpecificVerificationOptions;
import xades4j.verification.VerifierTestBase;
import xades4j.verification.XAdESForm;
import xades4j.verification.XAdESVerificationResult;
import xades4j.verification.XadesVerificationProfile;
import xades4j.verification.XadesVerifier;

public class XadesVerifierImplTest
extends VerifierTestBase {
    XadesVerificationProfile verificationProfile;
    XadesVerificationProfile nistVerificationProfile;

    @Before
    public void initialize() {
        this.verificationProfile = new XadesVerificationProfile(VerifierTestBase.validationProviderMySigs);
        this.nistVerificationProfile = new XadesVerificationProfile(VerifierTestBase.validationProviderNist);
    }

    @Test
    public void testVerifyBES() throws Exception {
        System.out.println("verifyBES");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.bes.xml");
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)f));
    }

    @Test(expected=CannotBuildCertificationPathException.class)
    public void testVerifyBESWithVerificationDate() throws Exception {
        System.out.println("testVerifyBESWithVerificationDate");
        String sigFilename = "document.signed.bes.xml";
        Element signatureNode = XadesVerifierImplTest.getSigElement(XadesVerifierImplTest.getDocument(sigFilename));
        XadesVerificationProfile p = new XadesVerificationProfile(VerifierTestBase.validationProviderMySigs);
        Date verificationDate = new SimpleDateFormat("YYYY").parse("2041");
        p.newVerifier().verify(signatureNode, new SignatureSpecificVerificationOptions().setDefaultVerificationDate(verificationDate));
    }

    @Test(expected=InvalidSignatureException.class)
    public void testVerifyWithCustomRawVerifier() throws Exception {
        System.out.println("verifyWithCustomRawVerifier");
        this.verificationProfile.withRawSignatureVerifier(new RawSignatureVerifier(){

            @Override
            public void verify(RawSignatureVerifier.RawSignatureVerifierContext ctx) throws InvalidSignatureException {
                throw new InvalidSignatureException("Rejected by RawSignatureVerifier");
            }
        });
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.bes.xml", this.verificationProfile);
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)f));
    }

    @Test
    public void testVerifyDetachedBES() throws Exception {
        System.out.println("verifyDetachedBES");
        XAdESForm f = XadesVerifierImplTest.verifySignature("detached.bes.xml", new SignatureSpecificVerificationOptions().useBaseUri(new File("src/test/xml/").toURI().toString()));
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)f));
    }

    @Test
    public void testVerifyBESCounterSig() throws Exception {
        System.out.println("verifyBESCounterSig");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.bes.cs.xml");
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)f));
    }

    @Test
    public void testVerifyBESCounterSigCounterSig() throws Exception {
        System.out.println("verifyBESCounterSigCounterSig");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.bes.cs.cs.xml");
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)f));
    }

    @Test
    public void testVerifyBESEnrichT() throws Exception {
        System.out.println("verifyBESEnrichT");
        Document doc = XadesVerifierImplTest.getDocument("document.signed.bes.xml");
        Element signatureNode = XadesVerifierImplTest.getSigElement(doc);
        XadesSignatureFormatExtender formExt = new XadesFormatExtenderProfile().getFormatExtender();
        XAdESVerificationResult res = this.verificationProfile.newVerifier().verify(signatureNode, null, formExt, XAdESForm.T);
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)res.getSignatureForm()));
        res = this.verificationProfile.newVerifier().verify(signatureNode, null);
        Assert.assertEquals((Object)((Object)XAdESForm.T), (Object)((Object)res.getSignatureForm()));
        XadesVerifierImplTest.outputDocument(doc, "document.verified.bes.t.xml");
    }

    @Test
    public void testVerifyBESExtrnlResEnrichC() throws Exception {
        System.out.println("verifyBESExtrnlResEnrichC");
        Document doc = XadesVerifierImplTest.getDocument("document.signed.bes.extres.xml");
        Element signatureNode = XadesVerifierImplTest.getSigElement(doc);
        SignatureSpecificVerificationOptions options = new SignatureSpecificVerificationOptions().useBaseUri("http://www.ietf.org/rfc/");
        XadesSignatureFormatExtender formExt = new XadesFormatExtenderProfile().getFormatExtender();
        XAdESVerificationResult res = this.nistVerificationProfile.newVerifier().verify(signatureNode, options, formExt, XAdESForm.C);
        Assert.assertEquals((Object)((Object)XAdESForm.BES), (Object)((Object)res.getSignatureForm()));
        res = this.nistVerificationProfile.newVerifier().verify(signatureNode, options);
        Assert.assertEquals((Object)((Object)XAdESForm.C), (Object)((Object)res.getSignatureForm()));
        XadesVerifierImplTest.outputDocument(doc, "document.verified.bes.extres.c.xml");
    }

    @Test
    public void testVerifyTBES() throws Exception {
        System.out.println("verifyTBES");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.t.bes.xml");
        Assert.assertEquals((Object)((Object)XAdESForm.T), (Object)((Object)f));
    }

    @Test
    public void testVerifyEPES() throws Exception {
        System.out.println("verifyEPES");
        this.verificationProfile.withPolicyDocumentProvider(VerifierTestBase.policyDocumentFinder);
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.epes.xml", this.verificationProfile);
        Assert.assertEquals((Object)((Object)XAdESForm.EPES), (Object)((Object)f));
    }

    @Test
    public void testVerifyTEPES() throws Exception {
        System.out.println("verifyTEPES");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.t.epes.xml");
        Assert.assertEquals((Object)((Object)XAdESForm.T), (Object)((Object)f));
    }

    @Test
    public void testVerifyTPTCC() throws Exception {
        System.out.println("verifyTPtCC");
        Assume.assumeTrue((XadesVerifierImplTest.onWindowsPlatform() && validationProviderPtCc != null ? 1 : 0) != 0);
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.t.bes.ptcc.xml", new XadesVerificationProfile(validationProviderPtCc));
        Assert.assertEquals((Object)((Object)XAdESForm.T), (Object)((Object)f));
    }

    @Test
    public void testVerifyC() throws Exception {
        System.out.println("verifyC");
        XAdESForm f = XadesVerifierImplTest.verifySignature("document.signed.c.xml", this.nistVerificationProfile);
        Assert.assertEquals((Object)((Object)XAdESForm.C), (Object)((Object)f));
    }

    @Test
    public void testVerifyDetachedC() throws Exception {
        System.out.println("verifyDetachedC");
        Document doc = XadesVerifierImplTest.getDocument("detached.c.xml");
        Element signatureNode = XadesVerifierImplTest.getSigElement(doc);
        XadesVerifier verifier = this.nistVerificationProfile.newVerifier();
        FileInputStream is = new FileInputStream("license.txt");
        SignatureSpecificVerificationOptions options = new SignatureSpecificVerificationOptions().useDataForAnonymousReference(is);
        XAdESVerificationResult res = verifier.verify(signatureNode, options);
        ((InputStream)is).close();
        Assert.assertEquals((Object)((Object)XAdESForm.C), (Object)((Object)res.getSignatureForm()));
    }

    @Test
    public void testVerifyCEnrichXL() throws Exception {
        System.out.println("verifyCEnrichXL");
        Document doc = XadesVerifierImplTest.getDocument("document.signed.c.xml");
        Element signatureNode = XadesVerifierImplTest.getSigElement(doc);
        XadesSignatureFormatExtender formExt = new XadesFormatExtenderProfile().getFormatExtender();
        XAdESVerificationResult res = this.nistVerificationProfile.newVerifier().verify(signatureNode, null, formExt, XAdESForm.X_L);
        Assert.assertEquals((Object)((Object)XAdESForm.C), (Object)((Object)res.getSignatureForm()));
        XadesVerifierImplTest.assertPropElementPresent(signatureNode, "SigAndRefsTimeStamp");
        XadesVerifierImplTest.assertPropElementPresent(signatureNode, "CertificateValues");
        XadesVerifierImplTest.assertPropElementPresent(signatureNode, "RevocationValues");
        XadesVerifierImplTest.outputDocument(doc, "document.verified.c.xl.xml");
    }

    private static void assertPropElementPresent(Element sigElem, String elemName) {
        NodeList props = sigElem.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", elemName);
        Assert.assertFalse((props.getLength() == 0 ? 1 : 0) != 0);
    }
}

