/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.GenericAlgorithm;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.utils.CollectionUtils;
import xades4j.xml.bind.xades.XmlEncapsulatedPKIDataType;
import xades4j.xml.bind.xades.XmlXAdESTimeStampType;
import xades4j.xml.bind.xmldsig.XmlCanonicalizationMethodType;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;

abstract class FromXmlBaseTimeStampConverter<TPropData extends BaseXAdESTimeStampData> {
    private final String propName;

    protected FromXmlBaseTimeStampConverter(String propName) {
        this.propName = propName;
    }

    protected void convertTimeStamps(List<XmlXAdESTimeStampType> xmlTimeStamps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        if (xmlTimeStamps == null || xmlTimeStamps.isEmpty()) {
            return;
        }
        for (XmlXAdESTimeStampType xmlTS : xmlTimeStamps) {
            GenericAlgorithm c14n;
            if (!xmlTS.getReferenceInfo().isEmpty()) {
                throw new PropertyUnmarshalException("ReferenceInfo is not supported in XAdESTimeStamp", this.propName);
            }
            XmlCanonicalizationMethodType xmlCanonMethod = xmlTS.getCanonicalizationMethod();
            if (xmlCanonMethod == null) {
                c14n = new GenericAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", new Node[0]);
            } else {
                List<Node> params = CollectionUtils.filterByType(xmlCanonMethod.getContent(), Element.class);
                c14n = new GenericAlgorithm(xmlCanonMethod.getAlgorithm(), params);
            }
            TPropData tsData = this.createTSData(c14n);
            List<Object> tsTokens = xmlTS.getEncapsulatedTimeStampOrXMLTimeStamp();
            if (tsTokens.isEmpty()) {
                throw new PropertyUnmarshalException("No time-stamp tokens", this.propName);
            }
            for (Object tkn : tsTokens) {
                if (!(tkn instanceof XmlEncapsulatedPKIDataType)) {
                    throw new PropertyUnmarshalException("XML time-stamps are not supported", this.propName);
                }
                ((BaseXAdESTimeStampData)tsData).addTimeStampToken(((XmlEncapsulatedPKIDataType)tkn).getValue());
            }
            this.doSpecificConvert(xmlTS, tsData);
            this.setTSData(tsData, propertyDataCollector);
        }
    }

    protected abstract TPropData createTSData(Algorithm var1);

    protected void doSpecificConvert(XmlXAdESTimeStampType xmlTS, TPropData tsData) throws PropertyUnmarshalException {
        if (!xmlTS.getInclude().isEmpty()) {
            throw new PropertyUnmarshalException("Includes should not be present", "");
        }
    }

    protected abstract void setTSData(TPropData var1, QualifyingPropertiesDataCollector var2);
}

