/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.List;
import javax.xml.bind.JAXBElement;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.xml.bind.xades.XmlAnyType;
import xades4j.xml.bind.xades.XmlSigPolicyQualifiersListType;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdType;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdentifierType;
import xades4j.xml.bind.xades.XmlSignedSignaturePropertiesType;
import xades4j.xml.unmarshalling.FromXmlUtils;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.SignedSigPropFromXmlConv;

class FromXmlSignaturePolicyConverter
implements SignedSigPropFromXmlConv {
    FromXmlSignaturePolicyConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlSignedSignaturePropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        XmlSignaturePolicyIdentifierType xmlSigPolicy = xmlProps.getSignaturePolicyIdentifier();
        if (xmlSigPolicy == null) {
            return;
        }
        if (xmlSigPolicy.getSignaturePolicyImplied() != null) {
            propertyDataCollector.setSignaturePolicy(new SignaturePolicyData());
            return;
        }
        XmlSignaturePolicyIdType xmlPolicyId = xmlSigPolicy.getSignaturePolicyId();
        if (xmlPolicyId.getTransforms() != null) {
            throw new PropertyUnmarshalException("Signature policy transforms are not supported", "SignaturePolicyIdentifier");
        }
        propertyDataCollector.setSignaturePolicy(new SignaturePolicyData(FromXmlUtils.getObjectIdentifier(xmlPolicyId.getSigPolicyId()), xmlPolicyId.getSigPolicyHash().getDigestMethod().getAlgorithm(), xmlPolicyId.getSigPolicyHash().getDigestValue(), FromXmlSignaturePolicyConverter.getLocationUrl(xmlPolicyId.getSigPolicyQualifiers())));
    }

    private static String getLocationUrl(XmlSigPolicyQualifiersListType sigPolicyQualifiers) throws PropertyUnmarshalException {
        String locationUrl = null;
        List<XmlAnyType> xmlQualifiers = sigPolicyQualifiers.getSigPolicyQualifier();
        for (XmlAnyType xmlQualifier : xmlQualifiers) {
            JAXBElement xmlSPURI;
            List<Object> content = xmlQualifier.getContent();
            if (content.size() != 1 || !(content.get(0) instanceof JAXBElement) || !(xmlSPURI = (JAXBElement)content.get(0)).getName().getLocalPart().equals("SPURI") || !xmlSPURI.getName().getNamespaceURI().equals("http://uri.etsi.org/01903/v1.3.2#")) continue;
            locationUrl = (String)xmlSPURI.getValue();
        }
        return locationUrl;
    }
}

