/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import xades4j.utils.CollectionUtils;
import xades4j.xml.bind.xades.XmlQualifyingPropertiesType;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.QualifyingPropertyFromDOMConverter;
import xades4j.xml.unmarshalling.QualifyingPropertyFromXmlConverter;

abstract class UnmarshallerModule<TXml> {
    private final Collection<QualifyingPropertyFromXmlConverter<TXml>> converters;
    private Collection<QualifyingPropertyFromDOMConverter> domConverters;

    protected UnmarshallerModule(int nConvs) {
        this.converters = new ArrayList<QualifyingPropertyFromXmlConverter<TXml>>(nConvs);
    }

    protected void addConverter(QualifyingPropertyFromXmlConverter<TXml> c) {
        this.converters.add(c);
    }

    protected void addConverter(QualifyingPropertyFromDOMConverter c) {
        this.domConverters = CollectionUtils.newIfNull(this.domConverters, 2);
        this.domConverters.add(c);
    }

    void convertProperties(XmlQualifyingPropertiesType xmlQualifProps, Element qualifProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        TXml xmlProps = this.getXmlProps(xmlQualifProps);
        if (xmlProps == null) {
            return;
        }
        for (QualifyingPropertyFromXmlConverter<TXml> conv : this.converters) {
            conv.convertFromObjectTree(xmlProps, propertyDataCollector);
        }
        if (this.domConverters != null) {
            Element props = this.getProps(qualifProps);
            for (QualifyingPropertyFromDOMConverter conv : this.domConverters) {
                conv.convertFromDOMTree(props, propertyDataCollector);
            }
        }
    }

    protected abstract TXml getXmlProps(XmlQualifyingPropertiesType var1);

    protected abstract Element getProps(Element var1);

    protected abstract void setAcceptUnknownProperties(boolean var1);
}

