/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.w3c.dom.Element;
import xades4j.algorithms.Algorithm;
import xades4j.production.DataGenBaseTimeStamp;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertyDataGenerationException;
import xades4j.properties.ArchiveTimeStampProperty;
import xades4j.properties.data.ArchiveTimeStampData;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.TimeStampTokenProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.DOMHelper;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;

class DataGenArchiveTimeStamp
extends DataGenBaseTimeStamp<ArchiveTimeStampProperty> {
    @Inject
    public DataGenArchiveTimeStamp(AlgorithmsProviderEx algorithmsProvider, TimeStampTokenProvider timeStampTokenProvider, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(algorithmsProvider, timeStampTokenProvider, timeStampDigestInputFactory);
    }

    @Override
    protected void addPropSpecificTimeStampInput(ArchiveTimeStampProperty prop, TimeStampDigestInput digestInput, PropertiesDataGenerationContext ctx) throws CannotAddDataToDigestInputException, PropertyDataGenerationException {
        Element unsignedSigPropsElem = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties");
        if (unsignedSigPropsElem == null) {
            throw new PropertyDataGenerationException(prop, "no unsigned signature properties to get inputs");
        }
        try {
            List<Reference> refs = ctx.getReferences();
            for (Reference r : refs) {
                digestInput.addReference(r);
            }
            Element e = ctx.getTargetXmlSignature().getSignedInfo().getElement();
            digestInput.addNode(e);
            e = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            digestInput.addNode(e);
            KeyInfo ki = ctx.getTargetXmlSignature().getKeyInfo();
            if (ki != null) {
                digestInput.addNode(ki.getElement());
            }
            HashMap<String, Integer> propsCnt = new HashMap<String, Integer>(5);
            propsCnt.put("CertificateValues", 0);
            propsCnt.put("RevocationValues", 0);
            propsCnt.put("CompleteCertificateRefs", 0);
            propsCnt.put("CompleteRevocationRefs", 0);
            propsCnt.put("SignatureTimeStamp", 0);
            e = DOMHelper.getFirstChildElement(unsignedSigPropsElem);
            do {
                digestInput.addNode(e);
                Integer pCnt = (Integer)propsCnt.get(e.getLocalName());
                if (pCnt == null) continue;
                pCnt = pCnt + 1;
                propsCnt.put(e.getLocalName(), pCnt);
            } while ((e = DOMHelper.getNextSiblingElement(e)) != null);
            for (Map.Entry entry : propsCnt.entrySet()) {
                if ((Integer)entry.getValue() != 0) continue;
                throw new PropertyDataGenerationException(prop, String.format("no %s for input", entry.getKey()));
            }
            int i = 0;
            while (i < ctx.getTargetXmlSignature().getObjectLength()) {
                ObjectContainer obj = ctx.getTargetXmlSignature().getObjectItem(i);
                if (DOMHelper.getFirstDescendant(obj.getElement(), "http://uri.etsi.org/01903/v1.3.2#", "*") == null) {
                    digestInput.addNode(obj.getElement());
                }
                ++i;
            }
        }
        catch (CannotAddDataToDigestInputException ex) {
            throw new PropertyDataGenerationException(prop, "cannot create time stamp input", ex);
        }
    }

    @Override
    protected BaseXAdESTimeStampData createPropDataObj(ArchiveTimeStampProperty prop, Algorithm c14n, TimeStampTokenProvider.TimeStampTokenRes tsTknRes, PropertiesDataGenerationContext ctx) {
        prop.setTime(tsTknRes.timeStampTime);
        return new ArchiveTimeStampData(c14n, tsTknRes.encodedTimeStampToken);
    }
}

