/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.xml.security.signature.Reference;
import xades4j.algorithms.Algorithm;
import xades4j.production.DataGenBaseTimeStamp;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.IndividualDataObjsTimeStampProperty;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.IndividualDataObjsTimeStampData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.TimeStampTokenProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;

class DataGenIndivDataObjsTimeStamp
extends DataGenBaseTimeStamp<IndividualDataObjsTimeStampProperty> {
    @Inject
    public DataGenIndivDataObjsTimeStamp(TimeStampTokenProvider timeStampTokenProvider, AlgorithmsProviderEx algorithmsProvider, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(algorithmsProvider, timeStampTokenProvider, timeStampDigestInputFactory);
    }

    @Override
    protected void addPropSpecificTimeStampInput(IndividualDataObjsTimeStampProperty prop, TimeStampDigestInput digestInput, PropertiesDataGenerationContext ctx) throws CannotAddDataToDigestInputException {
        Collection<DataObjectDesc> targetDataObjs = prop.getTargetDataObjects();
        Map<DataObjectDesc, Reference> refsMaps = ctx.getReferencesMappings();
        for (DataObjectDesc dataObj : targetDataObjs) {
            Reference r = refsMaps.get(dataObj);
            digestInput.addReference(r);
        }
    }

    @Override
    protected BaseXAdESTimeStampData createPropDataObj(IndividualDataObjsTimeStampProperty prop, Algorithm c14n, TimeStampTokenProvider.TimeStampTokenRes tsTknRes, PropertiesDataGenerationContext ctx) {
        Collection<DataObjectDesc> targetDataObjs = prop.getTargetDataObjects();
        Map<DataObjectDesc, Reference> refsMaps = ctx.getReferencesMappings();
        ArrayList<String> includes = new ArrayList<String>(targetDataObjs.size());
        for (DataObjectDesc dataObj : targetDataObjs) {
            Reference r = refsMaps.get(dataObj);
            includes.add(String.valueOf('#') + r.getId());
        }
        prop.setTime(tsTknRes.timeStampTime);
        return new IndividualDataObjsTimeStampData(c14n, includes, tsTknRes.encodedTimeStampToken);
    }
}

