/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.production.DataObjectReference;
import xades4j.production.SignatureAppendingStrategies;
import xades4j.production.SignedDataObjects;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesBesSigningProfile;
import xades4j.production.XadesSigner;
import xades4j.properties.DataObjectDesc;

public class OtherSignerTests
extends SignerTestBase {
    @Test
    public void testSignAndAppendAsFirstChild() throws Exception {
        System.out.println("signAndAppendAsFirstChild");
        Document doc = OtherSignerTests.getTestDocument();
        Element root = doc.getDocumentElement();
        XadesSigner signer = new XadesBesSigningProfile(keyingProviderMy).newSigner();
        DataObjectDesc obj1 = new DataObjectReference(String.valueOf('#') + root.getAttribute("Id")).withTransform(new EnvelopedSignatureTransform());
        SignedDataObjects dataObjs = new SignedDataObjects(obj1);
        signer.sign(dataObjs, root, SignatureAppendingStrategies.AsFirstChild);
        Element firstChild = (Element)doc.getDocumentElement().getFirstChild();
        Assert.assertEquals((Object)"Signature", (Object)firstChild.getLocalName());
        Assert.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#", (Object)firstChild.getNamespaceURI());
    }

    @Test
    public void testSignUsingCustomResolver() throws Exception {
        System.out.println("signUsingCustomResolver");
        Document doc = OtherSignerTests.getNewDocument();
        XadesSigner signer = new XadesBesSigningProfile(keyingProviderMy).newSigner();
        MyResolverSpi resolverSpi = new MyResolverSpi();
        SignedDataObjects dataObjs = new SignedDataObjects().withSignedDataObject(new DataObjectReference("xades4j://ref")).withResourceResolver(new ResourceResolver((ResourceResolverSpi)resolverSpi));
        signer.sign(dataObjs, doc);
        Assert.assertEquals((long)1L, (long)resolverSpi.resolveCount);
    }

    class MyResolverSpi
    extends ResourceResolverSpi {
        private int resolveCount = 0;

        MyResolverSpi() {
        }

        public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
            XMLSignatureInput input = new XMLSignatureInput(context.attr.getValue().getBytes());
            ++this.resolveCount;
            return input;
        }

        public boolean engineCanResolveURI(ResourceResolverContext context) {
            return context.attr.getValue().startsWith("xades4j:");
        }
    }
}

