/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import java.util.ArrayList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;

public class DataObjectFormatPropertyTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWithIdentifier_String() {
        System.out.println("withIdentifier");
        String uri = "uri";
        DataObjectFormatProperty instance = new DataObjectFormatProperty();
        instance.withIdentifier(uri);
        Assert.assertEquals((Object)instance.getIdentifier().getIdentifier(), (Object)uri);
        instance.withIdentifier((ObjectIdentifier)null);
        Assert.assertNull((Object)instance.getIdentifier());
    }

    public void testWithIdentifier_String_IdentifierType() {
        System.out.println("withIdentifier");
        String identifier = "uri";
        IdentifierType type = IdentifierType.URI;
        DataObjectFormatProperty instance = new DataObjectFormatProperty();
        instance.withIdentifier(identifier, type);
        Assert.assertEquals((Object)identifier, (Object)instance.getIdentifier().getIdentifier());
        Assert.assertEquals((Object)((Object)type), (Object)((Object)instance.getIdentifier().getIdentifierType()));
    }

    @Test
    public void testWithDocumentationUri() {
        System.out.println("withDocumentationUri");
        String documentationUri = "doc";
        DataObjectFormatProperty instance = new DataObjectFormatProperty();
        instance.withDocumentationUri(null);
        Assert.assertTrue((boolean)instance.getDocumentationUris().isEmpty());
        instance.withDocumentationUri(documentationUri);
        Assert.assertEquals((long)instance.getDocumentationUris().size(), (long)1L);
    }

    @Test
    public void testWithDocumentationUris() {
        System.out.println("withDocumentationUris");
        ArrayList<String> documentationUris = new ArrayList<String>(1);
        DataObjectFormatProperty instance = new DataObjectFormatProperty();
        instance.withDocumentationUris(documentationUris);
        Assert.assertTrue((boolean)instance.getDocumentationUris().isEmpty());
        documentationUris.add("doc");
        instance.withDocumentationUris(documentationUris);
        Assert.assertEquals((long)instance.getDocumentationUris().size(), (long)1L);
    }

    @Test(expected=NullPointerException.class)
    public void testWithDocumentationUris_Null() {
        System.out.println("withDocumentationUris");
        DataObjectFormatProperty instance = new DataObjectFormatProperty();
        instance.withDocumentationUris(null);
    }
}

