/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties.data;

import java.util.Collection;
import xades4j.properties.data.BaseCertRefsData;
import xades4j.properties.data.CertRef;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataObjectStructureVerifier;
import xades4j.properties.data.PropertyDataStructureException;
import xades4j.utils.ObjectUtils;

class BaseCertRefsDataStructureVerifier
implements PropertyDataObjectStructureVerifier {
    private final String propName;

    public BaseCertRefsDataStructureVerifier(String propName) {
        this.propName = propName;
    }

    @Override
    public void verifyStructure(PropertyDataObject propData) throws PropertyDataStructureException {
        Collection<CertRef> certs = ((BaseCertRefsData)propData).getCertRefs();
        if (certs == null || certs.isEmpty()) {
            throw new PropertyDataStructureException("empty certificate reference list", this.propName);
        }
        for (CertRef certRef : certs) {
            if (certRef == null) {
                throw new PropertyDataStructureException("null certificate reference", this.propName);
            }
            if (!ObjectUtils.anyNull(certRef.issuerDN, certRef.serialNumber, certRef.digestAlgUri, certRef.digestValue)) continue;
            throw new PropertyDataStructureException("empty data on one or more certificate references", this.propName);
        }
    }
}

