/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.CanonicalXMLWithoutComments;
import xades4j.algorithms.GenericAlgorithm;
import xades4j.providers.AlgorithmsProviderEx;

public class DefaultAlgorithmsProviderEx
implements AlgorithmsProviderEx {
    private static final Map<String, Algorithm> signatureAlgsMaps = new HashMap<String, Algorithm>(2);

    static {
        signatureAlgsMaps.put("DSA", new GenericAlgorithm("http://www.w3.org/2000/09/xmldsig#dsa-sha1", new Node[0]));
        signatureAlgsMaps.put("RSA", new GenericAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", new Node[0]));
    }

    @Override
    public Algorithm getSignatureAlgorithm(String keyAlgorithmName) throws UnsupportedAlgorithmException {
        Algorithm sigAlg = signatureAlgsMaps.get(keyAlgorithmName);
        if (sigAlg == null) {
            throw new UnsupportedAlgorithmException("Signature algorithm not supported by the provider", keyAlgorithmName);
        }
        return sigAlg;
    }

    @Override
    public Algorithm getCanonicalizationAlgorithmForSignature() {
        return new CanonicalXMLWithoutComments();
    }

    @Override
    public Algorithm getCanonicalizationAlgorithmForTimeStampProperties() {
        return new CanonicalXMLWithoutComments();
    }

    @Override
    public String getDigestAlgorithmForDataObjsReferences() {
        return "http://www.w3.org/2001/04/xmlenc#sha256";
    }

    @Override
    public String getDigestAlgorithmForReferenceProperties() {
        return "http://www.w3.org/2001/04/xmlenc#sha256";
    }

    @Override
    public String getDigestAlgorithmForTimeStampProperties() {
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }
}

