/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import xades4j.providers.CannotBuildCertificationPathException;
import xades4j.providers.CannotSelectCertificateException;
import xades4j.providers.CertificateValidationException;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.ValidationData;
import xades4j.verification.UnexpectedJCAException;

public class PKIXCertificateValidationProvider
implements CertificateValidationProvider {
    private static final int DEFAULT_MAX_PATH_LENGTH = 6;
    private final KeyStore trustAnchors;
    private final boolean revocationEnabled;
    private final int maxPathLength;
    private final CertStore[] intermCertsAndCrls;
    private final CertPathBuilder certPathBuilder;
    private final String signatureProvider;

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, int maxPathLength, String certPathBuilderProvider, String signatureProvider, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (trustAnchors == null) {
            throw new NullPointerException("Trust anchors cannot be null");
        }
        this.trustAnchors = trustAnchors;
        this.revocationEnabled = revocationEnabled;
        this.maxPathLength = maxPathLength;
        this.certPathBuilder = certPathBuilderProvider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", certPathBuilderProvider);
        this.signatureProvider = signatureProvider;
        this.intermCertsAndCrls = intermCertsAndCrls;
    }

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, String certPathBuilderProvider, String signatureProvider, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(trustAnchors, revocationEnabled, 6, certPathBuilderProvider, signatureProvider, intermCertsAndCrls);
    }

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, int maxPathLength, String jceProvider, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(trustAnchors, revocationEnabled, maxPathLength, jceProvider, jceProvider, intermCertsAndCrls);
    }

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, String jceProvider, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(trustAnchors, revocationEnabled, 6, jceProvider, intermCertsAndCrls);
    }

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, int maxPathLength, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(trustAnchors, revocationEnabled, maxPathLength, (String)null, (String)null, intermCertsAndCrls);
    }

    public PKIXCertificateValidationProvider(KeyStore trustAnchors, boolean revocationEnabled, CertStore ... intermCertsAndCrls) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(trustAnchors, revocationEnabled, 6, (String)null, (String)null, intermCertsAndCrls);
    }

    @Override
    public ValidationData validate(X509CertSelector certSelector, Date validationDate, Collection<X509Certificate> otherCerts) throws CertificateValidationException, UnexpectedJCAException {
        PKIXCertPathBuilderResult builderRes;
        PKIXBuilderParameters builderParams;
        try {
            builderParams = new PKIXBuilderParameters(this.trustAnchors, (CertSelector)certSelector);
        }
        catch (KeyStoreException ex) {
            throw new CannotBuildCertificationPathException(certSelector, "Trust anchors KeyStore is not initialized", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new CannotBuildCertificationPathException(certSelector, "Trust anchors KeyStore has no trusted certificate entries", ex);
        }
        try {
            if (otherCerts != null) {
                CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(otherCerts);
                CertStore othersCertStore = CertStore.getInstance("Collection", ccsp);
                builderParams.addCertStore(othersCertStore);
            }
            int i = 0;
            while (i < this.intermCertsAndCrls.length) {
                builderParams.addCertStore(this.intermCertsAndCrls[i]);
                ++i;
            }
            builderParams.setRevocationEnabled(this.revocationEnabled);
            builderParams.setMaxPathLength(this.maxPathLength);
            builderParams.setDate(validationDate);
            builderParams.setSigProvider(this.signatureProvider);
            builderRes = (PKIXCertPathBuilderResult)this.certPathBuilder.build(builderParams);
        }
        catch (CertPathBuilderException ex) {
            throw new CannotBuildCertificationPathException(certSelector, ex.getMessage(), ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new CannotSelectCertificateException(certSelector, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnexpectedJCAException("No provider for Collection CertStore", ex);
        }
        List<? extends Certificate> certPath = builderRes.getCertPath().getCertificates();
        certPath = new ArrayList<Certificate>(certPath);
        certPath.add(builderRes.getTrustAnchor().getTrustedCert());
        if (this.revocationEnabled) {
            return new ValidationData(certPath, this.getCRLsForCertPath(certPath, validationDate));
        }
        return new ValidationData(certPath);
    }

    private Collection<X509CRL> getCRLsForCertPath(List<X509Certificate> certPath, Date validationDate) throws CertificateValidationException {
        HashMap<X500Principal, X509Certificate> issuersCerts = new HashMap<X500Principal, X509Certificate>(certPath.size() - 1);
        int i = 0;
        while (i < certPath.size() - 1) {
            issuersCerts.put(certPath.get(i).getIssuerX500Principal(), certPath.get(i + 1));
            ++i;
        }
        X509CRLSelector crlSelector = new X509CRLSelector();
        for (X500Principal issuer : issuersCerts.keySet()) {
            crlSelector.addIssuer(issuer);
        }
        crlSelector.setDateAndTime(validationDate);
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        try {
            int i2 = 0;
            while (i2 < this.intermCertsAndCrls.length) {
                Collection<? extends CRL> storeCRLs = this.intermCertsAndCrls[i2].getCRLs(crlSelector);
                crls.addAll(Collections.checkedCollection(storeCRLs, X509CRL.class));
                ++i2;
            }
        }
        catch (CertStoreException ex) {
            throw new CertificateValidationException(null, "Cannot get CRLs", ex);
        }
        for (X509CRL crl : crls) {
            try {
                X509Certificate crlIssuerCert = (X509Certificate)issuersCerts.get(crl.getIssuerX500Principal());
                if (this.signatureProvider == null) {
                    crl.verify(crlIssuerCert.getPublicKey());
                    continue;
                }
                crl.verify(crlIssuerCert.getPublicKey(), this.signatureProvider);
            }
            catch (Exception ex) {
                throw new CertificateValidationException(null, "Invalid CRL signature from " + crl.getIssuerX500Principal().getName(), ex);
            }
        }
        return crls;
    }
}

