/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import org.junit.Before;
import org.junit.Test;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.SigningTimeData;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.SigningTimeVerificationException;
import xades4j.verification.SigningTimeVerifierThatDependsOnBuiltInVerifier;
import xades4j.verification.VerifierTestBase;
import xades4j.verification.XadesVerificationProfile;

public class OtherVerifierTests
extends VerifierTestBase {
    XadesVerificationProfile mySigsVerificationProfile;

    @Before
    public void initialize() {
        this.mySigsVerificationProfile = new XadesVerificationProfile(VerifierTestBase.validationProviderMySigs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testVerifyBESCustomPropVer() throws Exception {
        System.out.println("verifyBESCustomPropVer");
        this.mySigsVerificationProfile.withQualifyingPropertyVerifier(SigningTimeData.class, new QualifyingPropertyVerifier<SigningTimeData>(){

            @Override
            public QualifyingProperty verify(SigningTimeData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
                throw new UnsupportedOperationException("Yeah!");
            }
        });
        OtherVerifierTests.verifySignature("document.signed.bes.xml", this.mySigsVerificationProfile);
    }

    @Test(expected=SigningTimeVerificationException.class)
    public void testCustomVerifierCanUseBuiltInVerifier() throws Exception {
        System.out.println("customVerifierCanUseBuiltInVerifier");
        this.mySigsVerificationProfile.withQualifyingPropertyVerifier(SigningTimeData.class, SigningTimeVerifierThatDependsOnBuiltInVerifier.class);
        OtherVerifierTests.verifySignature("document.signed.bes.xml", this.mySigsVerificationProfile);
    }
}

