/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.algorithms.XPathTransform;
import xades4j.utils.SignatureServicesTestBase;
import xades4j.xml.marshalling.algorithms.XPathTransformParamsMarshaller;

public class XPathTransformParamsMarshallerTest {
    private Document doc;
    private XPathTransformParamsMarshaller sut;

    @Before
    public void setUp() throws Exception {
        this.doc = SignatureServicesTestBase.getNewDocument();
        this.sut = new XPathTransformParamsMarshaller();
    }

    @Test
    public void testMarshalXPathParametersWithNamespacePrefixes() throws Exception {
        XPathTransform xpath = new XPathTransform("foo:elem1/bar:elem2").withNamespace("foo", "http://test.xades4j/ns1").withNamespace("bar", "http://test.xades4j/ns2");
        List<Node> params = this.sut.marshalParameters(xpath, this.doc);
        Assert.assertEquals((long)1L, (long)params.size());
        Element paramNode = (Element)params.get(0);
        Map<String, String> namespaces = xpath.getNamespaces();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            String ns = paramNode.getAttributeNS("http://www.w3.org/2000/xmlns/", entry.getKey());
            Assert.assertNotNull((Object)ns);
            Assert.assertFalse((boolean)ns.isEmpty());
            Assert.assertEquals((Object)entry.getValue(), (Object)ns);
        }
    }
}

