/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.HashSet;
import java.util.List;
import xades4j.properties.data.SignerRoleData;
import xades4j.xml.bind.xades.XmlAnyType;
import xades4j.xml.bind.xades.XmlSignedSignaturePropertiesType;
import xades4j.xml.bind.xades.XmlSignerRoleType;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.SignedSigPropFromXmlConv;

class FromXmlSignerRoleConverter
implements SignedSigPropFromXmlConv {
    FromXmlSignerRoleConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlSignedSignaturePropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        XmlSignerRoleType xmlSignerRole = xmlProps.getSignerRole();
        if (xmlSignerRole == null) {
            return;
        }
        if (xmlSignerRole.getCertifiedRoles() != null) {
            throw new PropertyUnmarshalException("certified roles not supported", "SignerRole");
        }
        HashSet<String> claimedRoles = new HashSet<String>();
        for (XmlAnyType xmlRole : xmlSignerRole.getClaimedRoles().getClaimedRole()) {
            List<Object> contents = xmlRole.getContent();
            if (contents.size() != 1 || !(contents.get(0) instanceof String)) {
                throw new PropertyUnmarshalException("unsupported claimed role. Only one string is supported", "SignerRole");
            }
            claimedRoles.add((String)contents.get(0));
        }
        propertyDataCollector.setSignerRole(new SignerRoleData(claimedRoles));
    }
}

