/*
 * Decompiled with CFR 0.152.
 */
package xades4j.algorithms;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import xades4j.algorithms.XPath2FilterTransform;

public class XPath2FilterTransformTest {
    @Test
    public void testCreation() {
        XPath2FilterTransform t1 = XPath2FilterTransform.XPath2Filter.intersect("1");
        XPath2FilterTransform t2 = t1.union("2");
        XPath2FilterTransform t3 = t2.subtract("3");
        Assert.assertSame((Object)t1, (Object)t2);
        Assert.assertSame((Object)t2, (Object)t3);
        List<XPath2FilterTransform.XPath2Filter> filters = t3.getFilters();
        Assert.assertEquals((long)3L, (long)filters.size());
        XPath2FilterTransform.XPath2Filter f = filters.get(0);
        Assert.assertEquals((Object)"1", (Object)f.getXPath());
        Assert.assertEquals((Object)"intersect", (Object)f.getFilterType());
        f = filters.get(1);
        Assert.assertEquals((Object)"2", (Object)f.getXPath());
        Assert.assertEquals((Object)"union", (Object)f.getFilterType());
        f = filters.get(2);
        Assert.assertEquals((Object)"3", (Object)f.getXPath());
        Assert.assertEquals((Object)"subtract", (Object)f.getFilterType());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testChangeFiltersListFails() {
        XPath2FilterTransform t = XPath2FilterTransform.XPath2Filter.intersect("1").union("2");
        t.getFilters().clear();
    }
}

