/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.io.File;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.algorithms.XPath2FilterTransform;
import xades4j.algorithms.XPathTransform;
import xades4j.production.DataObjectReference;
import xades4j.production.EnvelopedXmlObject;
import xades4j.production.SignedDataObjects;
import xades4j.production.SignerBES;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesBesSigningProfile;
import xades4j.production.XadesSigner;
import xades4j.properties.AllDataObjsCommitmentTypeProperty;
import xades4j.properties.CommitmentTypeProperty;
import xades4j.properties.CounterSignatureProperty;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.properties.IndividualDataObjsTimeStampProperty;
import xades4j.properties.SignerRoleProperty;
import xades4j.providers.SignaturePropertiesCollector;
import xades4j.providers.SignaturePropertiesProvider;
import xades4j.providers.impl.DefaultBasicSignatureOptionsProvider;

public class SignerBESTest
extends SignerTestBase {
    @Test
    public void testSignBES() throws Exception {
        System.out.println("signBES");
        Document doc1 = SignerBESTest.getTestDocument();
        Document doc2 = SignerBESTest.getDocument("content.xml");
        Node objectContent = doc1.importNode(doc2.getDocumentElement(), true);
        Element elemToSign = doc1.getDocumentElement();
        SignerBES signer = (SignerBES)new XadesBesSigningProfile(keyingProviderMy).newSigner();
        IndividualDataObjsTimeStampProperty dataObjsTimeStamp = new IndividualDataObjsTimeStampProperty();
        AllDataObjsCommitmentTypeProperty globalCommitment = AllDataObjsCommitmentTypeProperty.proofOfApproval();
        CommitmentTypeProperty commitment = (CommitmentTypeProperty)CommitmentTypeProperty.proofOfCreation().withQualifier("MyQualifier");
        DataObjectDesc obj1 = new DataObjectReference(String.valueOf('#') + elemToSign.getAttribute("Id")).withTransform(new EnvelopedSignatureTransform()).withDataObjectFormat(new DataObjectFormatProperty("text/xml", "MyEncoding").withDescription("Isto \u00e9 uma descri\u00e7\u00e3o do elemento raiz").withDocumentationUri("http://doc1.txt").withDocumentationUri("http://doc2.txt").withIdentifier("http://elem.root")).withCommitmentType(commitment).withDataObjectTimeStamp(dataObjsTimeStamp);
        DataObjectDesc obj2 = new EnvelopedXmlObject(objectContent, "text/xml", null).withDataObjectFormat(new DataObjectFormatProperty("text/xml", "MyEncoding").withDescription("Isto \u00e9 uma descri\u00e7\u00e3o do elemento dentro do object").withDocumentationUri("http://doc3.txt").withDocumentationUri("http://doc4.txt").withIdentifier("http://elem.in.object")).withCommitmentType(commitment).withDataObjectTimeStamp(dataObjsTimeStamp);
        SignedDataObjects dataObjs = new SignedDataObjects(obj1, obj2).withCommitmentType(globalCommitment).withDataObjectsTimeStamp();
        signer.sign(dataObjs, elemToSign);
        SignerBESTest.outputDocument(doc1, "document.signed.bes.xml");
    }

    @Test
    public void testSignBESExtrnlRes() throws Exception {
        System.out.println("signBESExtrnlRes");
        Document doc = SignerBESTest.getNewDocument();
        SignerBES signer = (SignerBES)new XadesBesSigningProfile(keyingProviderNist).newSigner();
        DataObjectDesc obj1 = new DataObjectReference("rfc3161.txt").withDataObjectFormat(new DataObjectFormatProperty("text/plain").withDescription("Internet X.509 Public Key Infrastructure Time-Stamp Protocol (TSP)")).withDataObjectTimeStamp(new IndividualDataObjsTimeStampProperty());
        signer.sign(new SignedDataObjects(obj1).withBaseUri("http://www.ietf.org/rfc/"), doc);
        SignerBESTest.outputDocument(doc, "document.signed.bes.extres.xml");
    }

    @Test
    public void testSignBESWithCounterSig() throws Exception {
        System.out.println("signBESWithCounterSig");
        Document doc = SignerBESTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        XadesBesSigningProfile profile = new XadesBesSigningProfile(keyingProviderMy);
        XadesSigner counterSigner = profile.newSigner();
        profile.withSignaturePropertiesProvider(new SignaturePropertiesProvider(){

            @Override
            public void provideProperties(SignaturePropertiesCollector signedPropsCol) {
                signedPropsCol.addCounterSignature(new CounterSignatureProperty(counterSigner));
                signedPropsCol.setSignerRole(new SignerRoleProperty("CounterSignature maniac"));
            }
        });
        SignerBES signer = (SignerBES)profile.newSigner();
        DataObjectDesc obj1 = new DataObjectReference(String.valueOf('#') + elemToSign.getAttribute("Id")).withTransform(new EnvelopedSignatureTransform());
        SignedDataObjects dataObjs = new SignedDataObjects().withSignedDataObject(obj1);
        signer.sign(dataObjs, elemToSign);
        SignerBESTest.outputDocument(doc, "document.signed.bes.cs.xml");
    }

    @Test
    public void testSignBESDetachedWithXPathAndNamespaces() throws Exception {
        System.out.println("signBESDetachedWithXPathAndNamespaces");
        Document doc = SignerBESTest.getNewDocument();
        XadesSigner signer = new XadesBesSigningProfile(keyingProviderMy).withBasicSignatureOptionsProvider(MyBasicSignatureOptionsProvider.class).newSigner();
        DataObjectDesc obj1 = new DataObjectReference("document.xml").withTransform(new XPathTransform("/collection/album/foo:tracks").withNamespace("foo", "http://test.xades4j/tracks")).withDataObjectFormat(new DataObjectFormatProperty("text/xml"));
        DataObjectDesc obj2 = new DataObjectReference("document.xml").withTransform(XPath2FilterTransform.XPath2Filter.intersect("/collection/album/bar:tracks/bar:song[@tracknumber = 1]").withNamespace("bar", "http://test.xades4j/tracks"));
        SignedDataObjects objs = new SignedDataObjects(obj1, obj2).withBaseUri(new File("src/test/xml/").toURI().toString());
        signer.sign(objs, doc);
        SignerBESTest.outputDocument(doc, "detached.bes.xml");
    }

    public static class MyBasicSignatureOptionsProvider
    extends DefaultBasicSignatureOptionsProvider {
        @Override
        public boolean signSigningCertificate() {
            return true;
        }
    }
}

