/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import xades4j.UnsupportedAlgorithmException;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.TimeStampTokenGenerationException;
import xades4j.providers.TimeStampTokenProvider;

public abstract class AbstractTimeStampTokenProvider
implements TimeStampTokenProvider {
    private static final Map<String, ASN1ObjectIdentifier> digestUriToOidMappings = new HashMap<String, ASN1ObjectIdentifier>(6);
    private final MessageDigestEngineProvider messageDigestProvider;
    private final TimeStampRequestGenerator tsRequestGenerator;

    static {
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmldsig-more#md5", TSPAlgorithms.MD5);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#ripemd160", TSPAlgorithms.RIPEMD160);
        digestUriToOidMappings.put("http://www.w3.org/2000/09/xmldsig#sha1", TSPAlgorithms.SHA1);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#sha256", TSPAlgorithms.SHA256);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmldsig-more#sha384", TSPAlgorithms.SHA384);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#sha512", TSPAlgorithms.SHA512);
    }

    private static ASN1ObjectIdentifier identifierForDigest(String digestAlgUri) {
        return digestUriToOidMappings.get(digestAlgUri);
    }

    @Inject
    AbstractTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider) {
        this.messageDigestProvider = messageDigestProvider;
        this.tsRequestGenerator = new TimeStampRequestGenerator();
        this.tsRequestGenerator.setCertReq(true);
    }

    @Override
    public final TimeStampTokenProvider.TimeStampTokenRes getTimeStampToken(byte[] tsDigestInput, String digestAlgUri) throws TimeStampTokenGenerationException {
        TimeStampTokenProvider.TimeStampTokenRes tsTokenRes;
        byte[] digest;
        try {
            MessageDigest md = this.messageDigestProvider.getEngine(digestAlgUri);
            digest = md.digest(tsDigestInput);
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new TimeStampTokenGenerationException("Digest algorithm not supported", ex);
        }
        TimeStampRequest tsRequest = this.tsRequestGenerator.generate(AbstractTimeStampTokenProvider.identifierForDigest(digestAlgUri), digest, BigInteger.valueOf(System.currentTimeMillis()));
        TimeStampResponse tsResponse = this.getTimeStampResponse(tsRequest);
        if (tsResponse.getStatus() != 0 && tsResponse.getStatus() != 1) {
            throw new TimeStampTokenGenerationException("Time stamp token not granted. " + tsResponse.getStatusString());
        }
        try {
            tsResponse.validate(tsRequest);
        }
        catch (TSPException ex) {
            throw new TimeStampTokenGenerationException("Invalid time stamp response", ex);
        }
        TimeStampToken tsToken = tsResponse.getTimeStampToken();
        try {
            tsTokenRes = new TimeStampTokenProvider.TimeStampTokenRes(tsToken.getEncoded(), tsToken.getTimeStampInfo().getGenTime());
        }
        catch (IOException ex) {
            throw new TimeStampTokenGenerationException("Encoding error", ex);
        }
        return tsTokenRes;
    }

    private TimeStampResponse getTimeStampResponse(TimeStampRequest tsRequest) throws TimeStampTokenGenerationException {
        TimeStampResponse tsResponse;
        try {
            byte[] responseStream = this.getResponse(tsRequest.getEncoded());
            tsResponse = new TimeStampResponse(responseStream);
        }
        catch (TSPException ex) {
            throw new TimeStampTokenGenerationException("Invalid time stamp response", ex);
        }
        catch (IOException ex) {
            throw new TimeStampTokenGenerationException("Encoding error", ex);
        }
        return tsResponse;
    }

    abstract byte[] getResponse(byte[] var1) throws TimeStampTokenGenerationException;
}

