/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.Selector;
import xades4j.UnsupportedAlgorithmException;
import xades4j.XAdES4jException;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.TimeStampTokenDigestException;
import xades4j.providers.TimeStampTokenSignatureException;
import xades4j.providers.TimeStampTokenStructureException;
import xades4j.providers.TimeStampTokenTSACertException;
import xades4j.providers.TimeStampTokenVerificationException;
import xades4j.providers.TimeStampVerificationProvider;
import xades4j.providers.ValidationData;

public class DefaultTimeStampVerificationProvider
implements TimeStampVerificationProvider {
    private static final Map<ASN1ObjectIdentifier, String> digestOidToUriMappings = new HashMap<ASN1ObjectIdentifier, String>(5);
    private final CertificateValidationProvider certificateValidationProvider;
    private final MessageDigestEngineProvider messageDigestProvider;
    private final JcaSimpleSignerInfoVerifierBuilder signerInfoVerifierBuilder;
    private final JcaX509CertificateConverter x509CertificateConverter;
    private final JcaX509CertSelectorConverter x509CertSelectorConverter;

    static {
        digestOidToUriMappings.put(TSPAlgorithms.MD5, "http://www.w3.org/2001/04/xmldsig-more#md5");
        digestOidToUriMappings.put(TSPAlgorithms.RIPEMD160, "http://www.w3.org/2001/04/xmlenc#ripemd160");
        digestOidToUriMappings.put(TSPAlgorithms.SHA1, "http://www.w3.org/2000/09/xmldsig#sha1");
        digestOidToUriMappings.put(TSPAlgorithms.SHA256, "http://www.w3.org/2001/04/xmlenc#sha256");
        digestOidToUriMappings.put(TSPAlgorithms.SHA384, "http://www.w3.org/2001/04/xmldsig-more#sha384");
        digestOidToUriMappings.put(TSPAlgorithms.SHA512, "http://www.w3.org/2001/04/xmlenc#sha512");
    }

    private static String uriForDigest(ASN1ObjectIdentifier digestalgOid) {
        return digestOidToUriMappings.get(digestalgOid);
    }

    @Inject
    public DefaultTimeStampVerificationProvider(CertificateValidationProvider certificateValidationProvider, MessageDigestEngineProvider messageDigestProvider) {
        this.certificateValidationProvider = certificateValidationProvider;
        this.messageDigestProvider = messageDigestProvider;
        BouncyCastleProvider bcProv = new BouncyCastleProvider();
        this.signerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)bcProv);
        this.x509CertificateConverter = new JcaX509CertificateConverter().setProvider((Provider)bcProv);
        this.x509CertSelectorConverter = new JcaX509CertSelectorConverter();
    }

    @Override
    public Date verifyToken(byte[] timeStampToken, byte[] tsDigestInput) throws TimeStampTokenVerificationException {
        TimeStampToken tsToken;
        try {
            ASN1InputStream asn1is = new ASN1InputStream(timeStampToken);
            ContentInfo tsContentInfo = ContentInfo.getInstance((Object)asn1is.readObject());
            asn1is.close();
            tsToken = new TimeStampToken(tsContentInfo);
        }
        catch (IOException ex) {
            throw new TimeStampTokenStructureException("Error parsing encoded token", ex);
        }
        catch (TSPException ex) {
            throw new TimeStampTokenStructureException("Invalid token", ex);
        }
        X509Certificate tsaCert = null;
        try {
            LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
            for (Object certHolder : tsToken.getCertificates().getMatches((Selector)new AllCertificatesSelector())) {
                certs.add(this.x509CertificateConverter.getCertificate((X509CertificateHolder)certHolder));
            }
            ValidationData vData = this.certificateValidationProvider.validate(this.x509CertSelectorConverter.getCertSelector(tsToken.getSID()), tsToken.getTimeStampInfo().getGenTime(), certs);
            tsaCert = vData.getCerts().get(0);
        }
        catch (CertificateException ex) {
            throw new TimeStampTokenVerificationException(ex.getMessage(), ex);
        }
        catch (XAdES4jException ex) {
            throw new TimeStampTokenTSACertException("cannot validate TSA certificate", ex);
        }
        try {
            tsToken.validate(this.signerInfoVerifierBuilder.build(tsaCert));
        }
        catch (TSPValidationException ex) {
            throw new TimeStampTokenSignatureException("Invalid token signature or certificate", ex);
        }
        catch (Exception ex) {
            throw new TimeStampTokenVerificationException("Error when verifying the token signature", ex);
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        try {
            String digestAlgUri = DefaultTimeStampVerificationProvider.uriForDigest(tsTokenInfo.getMessageImprintAlgOID());
            MessageDigest md = this.messageDigestProvider.getEngine(digestAlgUri);
            if (!Arrays.equals(md.digest(tsDigestInput), tsTokenInfo.getMessageImprintDigest())) {
                throw new TimeStampTokenDigestException();
            }
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new TimeStampTokenVerificationException("The token's digest algorithm is not supported", ex);
        }
        return tsTokenInfo.getGenTime();
    }

    private static class AllCertificatesSelector
    implements Selector {
        private AllCertificatesSelector() {
        }

        public boolean match(Object o) {
            return true;
        }

        public Object clone() {
            return this;
        }
    }
}

