/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import xades4j.providers.KeyingDataProvider;

public class DirectKeyingDataProvider
implements KeyingDataProvider {
    private final List<X509Certificate> certificates;
    private final PrivateKey key;

    public DirectKeyingDataProvider(X509Certificate certificate, PrivateKey key) {
        if (certificate == null || key == null) {
            throw new NullPointerException("Null key or certificate");
        }
        this.certificates = Collections.singletonList(certificate);
        this.key = key;
    }

    @Override
    public List<X509Certificate> getSigningCertificateChain() {
        return this.certificates;
    }

    @Override
    public PrivateKey getSigningKey(X509Certificate signingCert) {
        return this.key;
    }
}

