/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.SigningCertChainException;
import xades4j.providers.SigningKeyException;
import xades4j.verification.UnexpectedJCAException;

public abstract class KeyStoreKeyingDataProvider
implements KeyingDataProvider {
    private final KeyStoreBuilderCreator builderCreator;
    private final SigningCertSelector certificateSelector;
    private final KeyStorePasswordProvider storePasswordProvider;
    private final KeyEntryPasswordProvider entryPasswordProvider;
    private final boolean returnFullChain;
    private KeyStore keyStore;
    private final Object lockObj;
    private boolean initialized;

    protected KeyStoreKeyingDataProvider(KeyStoreBuilderCreator builderCreator, SigningCertSelector certificateSelector, KeyStorePasswordProvider storePasswordProvider, KeyEntryPasswordProvider entryPasswordProvider, boolean returnFullChain) {
        this.builderCreator = builderCreator;
        this.certificateSelector = certificateSelector;
        this.storePasswordProvider = storePasswordProvider;
        this.entryPasswordProvider = entryPasswordProvider;
        this.returnFullChain = returnFullChain;
        this.lockObj = new Object();
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() throws UnexpectedJCAException {
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.initialized) {
                try {
                    KeyStore.CallbackHandlerProtection storeLoadProtec = null;
                    storeLoadProtec = this.storePasswordProvider != null ? new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            PasswordCallback c = (PasswordCallback)callbacks[0];
                            c.setPassword(KeyStoreKeyingDataProvider.this.storePasswordProvider.getPassword());
                        }
                    }) : new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            throw new UnsupportedOperationException("No KeyStorePasswordProvider");
                        }
                    });
                    this.keyStore = this.builderCreator.getBuilder(storeLoadProtec).getKeyStore();
                }
                catch (KeyStoreException ex) {
                    throw new UnexpectedJCAException("The keystore couldn't be initialized", ex);
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public List<X509Certificate> getSigningCertificateChain() throws SigningCertChainException, UnexpectedJCAException {
        this.ensureInitialized();
        try {
            ArrayList<X509Certificate> availableSignCerts = new ArrayList<X509Certificate>(this.keyStore.size());
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cer;
                String alias = aliases.nextElement();
                if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || !((cer = this.keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                availableSignCerts.add((X509Certificate)cer);
            }
            if (availableSignCerts.isEmpty()) {
                throw new SigningCertChainException("No certificates available in the key store");
            }
            X509Certificate signingCert = this.certificateSelector.selectCertificate(availableSignCerts);
            String signingCertAlias = this.keyStore.getCertificateAlias(signingCert);
            if (signingCertAlias == null) {
                throw new SigningCertChainException("Selected certificate not present in the key store");
            }
            Certificate[] signingCertChain = this.keyStore.getCertificateChain(signingCertAlias);
            if (signingCertChain == null) {
                throw new SigningCertChainException("Selected certificate doesn't match a key and corresponding certificate chain");
            }
            if (this.returnFullChain) {
                List<Certificate> lChain = Arrays.asList(signingCertChain);
                return Collections.checkedList(lChain, X509Certificate.class);
            }
            return Collections.singletonList((X509Certificate)signingCertChain[0]);
        }
        catch (KeyStoreException ex) {
            throw new UnexpectedJCAException(ex.getMessage(), ex);
        }
    }

    @Override
    public PrivateKey getSigningKey(X509Certificate signingCert) throws SigningKeyException, UnexpectedJCAException {
        this.ensureInitialized();
        try {
            String entryAlias = this.keyStore.getCertificateAlias(signingCert);
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(entryAlias, this.getKeyProtection(entryAlias, signingCert, this.entryPasswordProvider));
            return entry.getPrivateKey();
        }
        catch (UnrecoverableKeyException ex) {
            throw new SigningKeyException("Invalid key entry password", ex);
        }
        catch (GeneralSecurityException ex) {
            throw new UnexpectedJCAException(ex.getMessage(), ex);
        }
    }

    protected abstract KeyStore.ProtectionParameter getKeyProtection(String var1, X509Certificate var2, KeyEntryPasswordProvider var3);

    public static interface KeyEntryPasswordProvider {
        public char[] getPassword(String var1, X509Certificate var2);
    }

    protected static interface KeyStoreBuilderCreator {
        public KeyStore.Builder getBuilder(KeyStore.ProtectionParameter var1);
    }

    public static interface KeyStorePasswordProvider {
        public char[] getPassword();
    }

    public static interface SigningCertSelector {
        public X509Certificate selectCertificate(List<X509Certificate> var1);
    }
}

