/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <T> Collection<T> newIfNull(Collection<T> c, int size) {
        if (c == null) {
            c = new ArrayList<T>(size);
        }
        return c;
    }

    public static <TK, TV> Map<TK, TV> newIfNull(Map<TK, TV> m, int size) {
        if (m == null) {
            m = new HashMap<TK, TV>(size);
        }
        return m;
    }

    public static <T> Collection<T> emptyIfNull(Collection<T> c) {
        if (c == null) {
            c = Collections.emptyList();
        }
        return c;
    }

    public static <TK, TV> Map<TK, TV> emptyIfNull(Map<TK, TV> m) {
        if (m == null) {
            m = Collections.emptyMap();
        }
        return m;
    }

    public static <T> Collection<T> cloneOrEmptyIfNull(Collection<T> c) {
        c = c == null ? new ArrayList<T>(0) : new ArrayList<T>(c);
        return c;
    }

    public static <TK, TV> Map<TK, TV> cloneOrEmptyIfNull(Map<TK, TV> m) {
        m = m == null ? new HashMap<TK, TV>(0) : new HashMap<TK, TV>(m);
        return m;
    }

    public static <T> boolean nullOrEmpty(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static <T> List<T> filter(Collection<T> c, Predicate<T> p) {
        ArrayList<T> filtered = new ArrayList<T>();
        for (T e : c) {
            if (!p.verifiedBy(e)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    public static <TSrc, TDest> List<TDest> project(Collection<TSrc> c, Projector<TSrc, TDest> p) {
        ArrayList<TDest> projected = new ArrayList<TDest>();
        for (TSrc e : c) {
            projected.add(p.project(e));
        }
        return projected;
    }

    public static <T, T1 extends T> List<T1> filterByType(Collection<T> c, final Class<T1> clazz) {
        return CollectionUtils.project(CollectionUtils.filter(c, new Predicate<T>(){

            @Override
            public boolean verifiedBy(T elem) {
                return clazz.isAssignableFrom(elem.getClass());
            }
        }), new Projector<T, T1>(){

            @Override
            public T1 project(T e) {
                return e;
            }
        });
    }

    public static interface Predicate<T> {
        public boolean verifiedBy(T var1);
    }

    public static interface Projector<T1, T2> {
        public T2 project(T1 var1);
    }
}

