/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SigningCertificateProperty;
import xades4j.properties.data.CertRef;
import xades4j.properties.data.SigningCertificateData;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.verification.CertRefUtils;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.SigningCertificateCertsNotInCertPathException;
import xades4j.verification.SigningCertificateIssuerSerialMismatchException;
import xades4j.verification.SigningCertificateReferenceException;
import xades4j.verification.SigningCertificateReferenceNotFoundException;
import xades4j.verification.SigningCertificateVerificationException;

class SigningCertificateVerifier
implements QualifyingPropertyVerifier<SigningCertificateData> {
    private final MessageDigestEngineProvider messageDigestProvider;

    @Inject
    public SigningCertificateVerifier(MessageDigestEngineProvider messageDigestProvider) {
        this.messageDigestProvider = messageDigestProvider;
    }

    @Override
    public QualifyingProperty verify(SigningCertificateData propData, QualifyingPropertyVerificationContext ctx) throws SigningCertificateVerificationException {
        Collection<CertRef> certRefs = propData.getCertRefs();
        QualifyingPropertyVerificationContext.CertificationChainData certChainData = ctx.getCertChainData();
        Iterator<X509Certificate> certPathIter = certChainData.getCertificateChain().iterator();
        X509Certificate signingCert = certPathIter.next();
        CertRef signingCertRef = CertRefUtils.findCertRef(signingCert, certRefs);
        if (signingCertRef == null) {
            throw new SigningCertificateReferenceNotFoundException(signingCert);
        }
        X500Principal keyInfoIssuer = certChainData.getValidationCertIssuer();
        if (!(keyInfoIssuer == null || new X500Principal(signingCertRef.issuerDN).equals(keyInfoIssuer) && signingCertRef.serialNumber.equals(certChainData.getValidationCertSerialNumber()))) {
            throw new SigningCertificateIssuerSerialMismatchException(signingCertRef.issuerDN, signingCertRef.serialNumber, keyInfoIssuer.getName(), certChainData.getValidationCertSerialNumber());
        }
        try {
            CertRefUtils.checkCertRef(signingCertRef, signingCert, this.messageDigestProvider);
        }
        catch (CertRefUtils.InvalidCertRefException ex) {
            throw new SigningCertificateReferenceException(signingCert, signingCertRef, ex);
        }
        int nMatchedRefs = 1;
        while (certPathIter.hasNext()) {
            X509Certificate cert = certPathIter.next();
            CertRef certRef = CertRefUtils.findCertRef(cert, certRefs);
            if (certRef == null) continue;
            ++nMatchedRefs;
            try {
                CertRefUtils.checkCertRef(certRef, cert, this.messageDigestProvider);
            }
            catch (CertRefUtils.InvalidCertRefException ex) {
                throw new SigningCertificateReferenceException(cert, certRef, ex);
            }
        }
        if (nMatchedRefs < certRefs.size()) {
            throw new SigningCertificateCertsNotInCertPathException();
        }
        return new SigningCertificateProperty(certChainData.getCertificateChain());
    }
}

