/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.algorithms.XPath2FilterTransform;
import xades4j.utils.SignatureServicesTestBase;
import xades4j.xml.marshalling.algorithms.XPath2FilterTransformParamsMarshaller;

public class XPath2FilterTransformParamsMarshallerTest {
    private Document doc;
    private XPath2FilterTransformParamsMarshaller sut;

    @Before
    public void setUp() throws Exception {
        this.doc = SignatureServicesTestBase.getNewDocument();
        this.sut = new XPath2FilterTransformParamsMarshaller();
    }

    @Test
    public void testMarshalXPathParametersWithNamespacePrefixes() throws Exception {
        XPath2FilterTransform xpath = XPath2FilterTransform.XPath2Filter.intersect("foo:elem1").union("bar:elem2").withNamespace("foo", "http://test.xades4j/ns1").withNamespace("bar", "http://test.xades4j/ns2");
        List<Node> params = this.sut.marshalParameters(xpath, this.doc);
        Assert.assertEquals((long)2L, (long)params.size());
        Set<Map.Entry<String, String>> namespaces = xpath.getNamespaces().entrySet();
        for (Node paramNode : params) {
            for (Map.Entry<String, String> entry : namespaces) {
                String ns = ((Element)paramNode).getAttributeNS("http://www.w3.org/2000/xmlns/", entry.getKey());
                Assert.assertNotNull((Object)ns);
                Assert.assertFalse((boolean)ns.isEmpty());
                Assert.assertEquals((Object)entry.getValue(), (Object)ns);
            }
        }
    }
}

