/*
 * Decompiled with CFR 0.152.
 */
package com.qprotex;

import com.qprotex.DirectPasswordProvider;
import com.qprotex.FirstCertificateSelector;
import com.qprotex.SignatureOptionsProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import xades4j.XAdES4jException;
import xades4j.production.Enveloped;
import xades4j.production.XadesEpesSigningProfile;
import xades4j.production.XadesSigner;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.SignaturePolicyBase;
import xades4j.properties.SignaturePolicyIdentifierProperty;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.SignaturePolicyInfoProvider;
import xades4j.providers.impl.FileSystemKeyStoreKeyingDataProvider;

public class Main {
    public static void main(String[] args) {
        OptionParser parser = new OptionParser(){
            {
                this.accepts("certificate").withRequiredArg().required().ofType(File.class).describedAs("certificate file");
                this.accepts("password").withRequiredArg().required().ofType(String.class).describedAs("certificate password");
                this.accepts("input").withRequiredArg().required().ofType(File.class).describedAs("input xml file");
                this.accepts("output").withRequiredArg().required().ofType(File.class).describedAs("output xml file");
            }
        };
        try {
            OptionSet options = parser.parse(args);
            new Main(options);
        }
        catch (OptionException e1) {
            try {
                parser.printHelpOn(System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Main(OptionSet options) {
        try {
            SignaturePolicyInfoProvider policyInfoProvider = new SignaturePolicyInfoProvider(){

                @Override
                public SignaturePolicyBase getSignaturePolicy() {
                    return new SignaturePolicyIdentifierProperty(new ObjectIdentifier("oid:/1.2.4.0.9.4.5", IdentifierType.OIDAsURI, "Policy description"), new ByteArrayInputStream("Test policy input stream".getBytes())).withLocationUrl("http://www.example.com/policy");
                }
            };
            FileSystemKeyStoreKeyingDataProvider kp = new FileSystemKeyStoreKeyingDataProvider("pkcs12", options.valueOf("certificate").toString(), new FirstCertificateSelector(), new DirectPasswordProvider(options.valueOf("password").toString()), new DirectPasswordProvider(options.valueOf("password").toString()), false);
            XadesEpesSigningProfile p = new XadesEpesSigningProfile((KeyingDataProvider)kp, policyInfoProvider);
            p.withBasicSignatureOptionsProvider(new SignatureOptionsProvider());
            XadesSigner signer = p.newSigner();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document doc1 = builder.parse(new File(options.valueOf("input").toString()));
            Element elemToSign = doc1.getDocumentElement();
            new Enveloped(signer).sign(elemToSign);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(new File(options.valueOf("output").toString()));
            DOMSource input = new DOMSource(doc1);
            transformer.transform(input, output);
        }
        catch (IOException | KeyStoreException | ParserConfigurationException | TransformerException | SAXException | XAdES4jException e) {
            e.printStackTrace();
        }
    }
}

