/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.util.HashMap;
import org.w3c.dom.Element;
import xades4j.algorithms.Algorithm;
import xades4j.production.DataGenBaseTimeStamp;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertyDataGenerationException;
import xades4j.properties.SigAndRefsTimeStampProperty;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.SigAndRefsTimeStampData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.TimeStampTokenProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.DOMHelper;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;

class DataGenSigAndRefsTimeStamp
extends DataGenBaseTimeStamp<SigAndRefsTimeStampProperty> {
    @Inject
    public DataGenSigAndRefsTimeStamp(AlgorithmsProviderEx algorithmsProvider, TimeStampTokenProvider timeStampTokenProvider, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(algorithmsProvider, timeStampTokenProvider, timeStampDigestInputFactory);
    }

    @Override
    protected void addPropSpecificTimeStampInput(SigAndRefsTimeStampProperty prop, TimeStampDigestInput digestInput, PropertiesDataGenerationContext ctx) throws CannotAddDataToDigestInputException, PropertyDataGenerationException {
        Element unsignedSigPropsElem = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties");
        if (unsignedSigPropsElem == null) {
            throw new PropertyDataGenerationException(prop, "no unsigned signature properties to get inputs");
        }
        HashMap<String, Integer> elegiblePropsCnt = new HashMap<String, Integer>(5);
        elegiblePropsCnt.put("CompleteCertificateRefs", 0);
        elegiblePropsCnt.put("CompleteRevocationRefs", 0);
        elegiblePropsCnt.put("SignatureTimeStamp", 0);
        elegiblePropsCnt.put("AttributeCertificateRefs", 0);
        elegiblePropsCnt.put("AttributeRevocationRefs", 0);
        try {
            Element e = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            digestInput.addNode(e);
            e = DOMHelper.getFirstChildElement(unsignedSigPropsElem);
            do {
                Integer pCnt;
                if ((pCnt = (Integer)elegiblePropsCnt.get(e.getLocalName())) == null) continue;
                pCnt = pCnt + 1;
                elegiblePropsCnt.put(e.getLocalName(), pCnt);
                digestInput.addNode(e);
            } while ((e = DOMHelper.getNextSiblingElement(e)) != null);
            if ((Integer)elegiblePropsCnt.get("SignatureTimeStamp") == 0) {
                throw new PropertyDataGenerationException(prop, "no signature time-stamps for input");
            }
            if ((Integer)elegiblePropsCnt.get("CompleteCertificateRefs") != 1) {
                throw new PropertyDataGenerationException(prop, "no CompleteCertificateRefs for input");
            }
            if ((Integer)elegiblePropsCnt.get("CompleteRevocationRefs") != 1) {
                throw new PropertyDataGenerationException(prop, "no CompleteRevocationRefs for input");
            }
        }
        catch (CannotAddDataToDigestInputException ex) {
            throw new PropertyDataGenerationException(prop, "cannot create timestamp input", ex);
        }
    }

    @Override
    protected BaseXAdESTimeStampData createPropDataObj(SigAndRefsTimeStampProperty prop, Algorithm c14n, TimeStampTokenProvider.TimeStampTokenRes tsTknRes, PropertiesDataGenerationContext ctx) {
        prop.setTime(tsTknRes.timeStampTime);
        return new SigAndRefsTimeStampData(c14n, tsTknRes.encodedTimeStampToken);
    }
}

