/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.production.KeyInfoBuilder;
import xades4j.production.TestAlgorithmsParametersMarshallingProvider;
import xades4j.production.TestAlgorithmsProvider;
import xades4j.providers.BasicSignatureOptionsProvider;
import xades4j.utils.SignatureServicesTestBase;

public class KeyInfoBuilderTest
extends SignatureServicesTestBase {
    private static X509Certificate testCertificate;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Init.init();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        testCertificate = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(KeyInfoBuilderTest.toPlatformSpecificCertDirFilePath("my/LG.cer")));
    }

    @Test
    public void testIncludeCertAndKey() throws Exception {
        System.out.println("includeCertAndKey");
        KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder(new TestBasicSignatureOptionsProvider(true, true, false), new TestAlgorithmsProvider(), new TestAlgorithmsParametersMarshallingProvider());
        XMLSignature xmlSignature = this.getTestSignature();
        keyInfoBuilder.buildKeyInfo(testCertificate, xmlSignature);
        Assert.assertEquals((int)0, (int)xmlSignature.getSignedInfo().getLength());
        KeyValue kv = xmlSignature.getKeyInfo().itemKeyValue(0);
        Assert.assertTrue((boolean)kv.getPublicKey().getAlgorithm().startsWith("RSA"));
        XMLX509Certificate x509Certificate = xmlSignature.getKeyInfo().itemX509Data(0).itemCertificate(0);
        Assert.assertEquals((Object)testCertificate, (Object)x509Certificate.getX509Certificate());
    }

    @Test
    public void testIgnoreSignSigningCertificateIfNotIncluded() throws Exception {
        System.out.println("ignoreSignSigningCertificateIfNotIncluded");
        KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder(new TestBasicSignatureOptionsProvider(false, true, true), new TestAlgorithmsProvider(), new TestAlgorithmsParametersMarshallingProvider());
        XMLSignature xmlSignature = this.getTestSignature();
        keyInfoBuilder.buildKeyInfo(testCertificate, xmlSignature);
        Assert.assertEquals((int)0, (int)xmlSignature.getSignedInfo().getLength());
        KeyValue kv = xmlSignature.getKeyInfo().itemKeyValue(0);
        Assert.assertTrue((boolean)kv.getPublicKey().getAlgorithm().startsWith("RSA"));
        Assert.assertEquals((int)0, (int)xmlSignature.getKeyInfo().lengthX509Data());
    }

    @Test
    public void testSignSigningCertificateIfIncluded() throws Exception {
        System.out.println("signSigningCertificateIfIncluded");
        KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder(new TestBasicSignatureOptionsProvider(true, true, true), new TestAlgorithmsProvider(), new TestAlgorithmsParametersMarshallingProvider());
        XMLSignature xmlSignature = this.getTestSignature();
        keyInfoBuilder.buildKeyInfo(testCertificate, xmlSignature);
        SignedInfo signedInfo = xmlSignature.getSignedInfo();
        Assert.assertEquals((int)1, (int)signedInfo.getLength());
        Node refNode = signedInfo.item(0).getContentsBeforeTransformation().getSubNode();
        Assert.assertSame((Object)xmlSignature.getKeyInfo().getElement(), (Object)refNode);
        Assert.assertEquals((int)1, (int)xmlSignature.getKeyInfo().lengthX509Data());
    }

    private XMLSignature getTestSignature() throws Exception {
        Document doc = KeyInfoBuilderTest.getNewDocument();
        XMLSignature xmlSignature = new XMLSignature(doc, "", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        xmlSignature.setId("sigId");
        doc.appendChild(xmlSignature.getElement());
        return xmlSignature;
    }

    static class TestBasicSignatureOptionsProvider
    implements BasicSignatureOptionsProvider {
        private final boolean includeSigningCertificate;
        private final boolean includePublicKey;
        private final boolean signSigningCertificate;

        public TestBasicSignatureOptionsProvider(boolean includeSigningCertificate, boolean includePublicKey, boolean signSigningCertificate) {
            this.includeSigningCertificate = includeSigningCertificate;
            this.includePublicKey = includePublicKey;
            this.signSigningCertificate = signSigningCertificate;
        }

        @Override
        public boolean includeSigningCertificate() {
            return this.includeSigningCertificate;
        }

        @Override
        public boolean includePublicKey() {
            return this.includePublicKey;
        }

        @Override
        public boolean signSigningCertificate() {
            return this.signSigningCertificate;
        }
    }
}

