/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.util.Map;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.production.AllwaysNullAlgsParamsMarshaller;
import xades4j.production.AnonymousDataObjectReference;
import xades4j.production.DataObjectReference;
import xades4j.production.EnvelopedXmlObject;
import xades4j.production.Init;
import xades4j.production.SignedDataObjects;
import xades4j.production.SignedDataObjectsProcessor;
import xades4j.production.TestAlgorithmsProvider;
import xades4j.properties.DataObjectDesc;
import xades4j.utils.SignatureServicesTestBase;
import xades4j.utils.StringUtils;

public class SignedDataObjectsProcessorTest
extends SignatureServicesTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Init.initXMLSec();
    }

    @Test
    public void testProcess() throws Exception {
        System.out.println("process");
        Document doc = SignedDataObjectsProcessorTest.getNewDocument();
        SignedDataObjects dataObjsDescs = new SignedDataObjects().withSignedDataObject(new DataObjectReference("uri").withTransform(new EnvelopedSignatureTransform())).withSignedDataObject(new EnvelopedXmlObject(doc.createElement("test1"))).withSignedDataObject(new EnvelopedXmlObject(doc.createElement("test2"), "text/xml", null));
        XMLSignature xmlSignature = new XMLSignature(doc, "", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        xmlSignature.setId("sigId");
        AllwaysNullAlgsParamsMarshaller algsParamsMarshaller = new AllwaysNullAlgsParamsMarshaller();
        SignedDataObjectsProcessor processor = new SignedDataObjectsProcessor(new TestAlgorithmsProvider(), algsParamsMarshaller);
        Map<DataObjectDesc, Reference> result = processor.process(dataObjsDescs, xmlSignature);
        Assert.assertEquals((long)dataObjsDescs.getDataObjectsDescs().size(), (long)result.size());
        Assert.assertEquals((long)2L, (long)xmlSignature.getObjectLength());
        Assert.assertEquals((long)xmlSignature.getSignedInfo().getLength(), (long)dataObjsDescs.getDataObjectsDescs().size());
        Assert.assertEquals((long)1L, (long)algsParamsMarshaller.getInvokeCount());
        Reference ref = xmlSignature.getSignedInfo().item(0);
        Assert.assertEquals((long)1L, (long)ref.getTransforms().getLength());
        ObjectContainer obj = xmlSignature.getObjectItem(1);
        Assert.assertEquals((Object)"text/xml", (Object)obj.getMimeType());
        Assert.assertTrue((boolean)StringUtils.isNullOrEmptyString(obj.getEncoding()));
    }

    @Test
    public void testAddNullReference() throws Exception {
        System.out.println("addNullReference");
        Document doc = SignatureServicesTestBase.getNewDocument();
        SignedDataObjects dataObjsDescs = new SignedDataObjects().withSignedDataObject(new AnonymousDataObjectReference("data".getBytes()));
        XMLSignature xmlSignature = new XMLSignature(doc, "", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        xmlSignature.setId("sigId");
        SignedDataObjectsProcessor processor = new SignedDataObjectsProcessor(new TestAlgorithmsProvider(), new AllwaysNullAlgsParamsMarshaller());
        Map<DataObjectDesc, Reference> result = processor.process(dataObjsDescs, xmlSignature);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)0L, (long)xmlSignature.getObjectLength());
        Assert.assertEquals((long)1L, (long)xmlSignature.getSignedInfo().getLength());
        Reference r = xmlSignature.getSignedInfo().item(0);
        Assert.assertNull((Object)r.getElement().getAttributeNodeNS("http://www.w3.org/2000/09/xmldsig#", "URI"));
    }

    @Test(expected=IllegalStateException.class)
    public void testAddMultipleNullReferencesFails() throws Exception {
        System.out.println("addMultipleNullReferencesFails");
        Document doc = SignatureServicesTestBase.getNewDocument();
        SignedDataObjects dataObjsDescs = new SignedDataObjects().withSignedDataObject(new AnonymousDataObjectReference("data1".getBytes())).withSignedDataObject(new AnonymousDataObjectReference("data2".getBytes()));
        XMLSignature xmlSignature = new XMLSignature(doc, "", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        xmlSignature.setId("sigId");
        SignedDataObjectsProcessor processor = new SignedDataObjectsProcessor(new TestAlgorithmsProvider(), new AllwaysNullAlgsParamsMarshaller());
        processor.process(dataObjsDescs, xmlSignature);
    }
}

