/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.io.ByteArrayInputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.production.Enveloped;
import xades4j.production.SignerEPES;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesEpesSigningProfile;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.SignaturePolicyBase;
import xades4j.properties.SignaturePolicyIdentifierProperty;
import xades4j.providers.SignaturePolicyInfoProvider;

public class SignerEPESTest
extends SignerTestBase {
    private SignaturePolicyInfoProvider policyInfoProvider;

    @Before
    public void setUp() throws Exception {
        this.policyInfoProvider = new SignaturePolicyInfoProvider(){

            @Override
            public SignaturePolicyBase getSignaturePolicy() {
                return new SignaturePolicyIdentifierProperty(new ObjectIdentifier("oid:/1.2.4.0.9.4.5", IdentifierType.OIDAsURI, "Policy description"), new ByteArrayInputStream("Test policy input stream".getBytes())).withLocationUrl("http://www.example.com/policy");
            }
        };
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSignEPES() throws Exception {
        System.out.println("signEPES");
        Document doc = SignerEPESTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        SignerEPES signer = (SignerEPES)new XadesEpesSigningProfile(keyingProviderMy, this.policyInfoProvider).newSigner();
        new Enveloped(signer).sign(elemToSign);
        SignerEPESTest.outputDocument(doc, "document.signed.epes.xml");
    }
}

