/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.ExclusiveCanonicalXMLWithoutComments;
import xades4j.production.Enveloped;
import xades4j.production.PtCcAlgorithmsProvider;
import xades4j.production.SignerT;
import xades4j.production.SignerTestBase;
import xades4j.production.XadesTSigningProfile;
import xades4j.properties.SignaturePolicyBase;
import xades4j.properties.SignaturePolicyImpliedProperty;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.SignaturePolicyInfoProvider;
import xades4j.providers.impl.DefaultAlgorithmsProviderEx;
import xades4j.providers.impl.FirstCertificateSelector;
import xades4j.providers.impl.HttpTimeStampTokenProvider;
import xades4j.providers.impl.PKCS11KeyStoreKeyingDataProvider;
import xades4j.providers.impl.TSAHttpData;

public class SignerTTest
extends SignerTestBase {
    @Test
    public void testSignTExclusiveC14NWithoutPolicy() throws Exception {
        System.out.println("signTExclusiveC14NWithoutPolicy");
        Document doc = SignerTTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        SignerT signer = (SignerT)new XadesTSigningProfile(keyingProviderMy).withTimeStampTokenProvider(TestTimeStampTokenProvider.class).withAlgorithmsProviderEx(ExclusiveC14nForTimeStampsAlgorithmsProvider.class).newSigner();
        new Enveloped(signer).sign(elemToSign);
        SignerTTest.outputDocument(doc, "document.signed.t.bes.xml");
    }

    @Test
    public void testSignTWithPolicy() throws Exception {
        System.out.println("signTWithPolicy");
        Document doc = SignerTTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        SignerT signer = (SignerT)new XadesTSigningProfile(keyingProviderMy).withPolicyProvider(new SignaturePolicyInfoProvider(){

            @Override
            public SignaturePolicyBase getSignaturePolicy() {
                return new SignaturePolicyImpliedProperty();
            }
        }).newSigner();
        new Enveloped(signer).sign(elemToSign);
        SignerTTest.outputDocument(doc, "document.signed.t.epes.xml");
    }

    @Test
    public void testSignTPtCC() throws Exception {
        System.out.println("signTPtCitizenCard");
        SignerTTest.assumePtCcPkcs11OnWindows();
        Document doc = SignerTTest.getTestDocument();
        Element elemToSign = doc.getDocumentElement();
        PKCS11KeyStoreKeyingDataProvider ptccKeyingDataProv = new PKCS11KeyStoreKeyingDataProvider(PTCC_PKCS11_LIB_PATH, "PT_CC", new FirstCertificateSelector(), null, null, false);
        SignerT signer = (SignerT)new XadesTSigningProfile(ptccKeyingDataProv).withAlgorithmsProviderEx(PtCcAlgorithmsProvider.class).newSigner();
        new Enveloped(signer).sign(elemToSign);
        SignerTTest.outputDocument(doc, "document.signed.t.bes.ptcc.xml");
    }

    static class ExclusiveC14nForTimeStampsAlgorithmsProvider
    extends DefaultAlgorithmsProviderEx {
        ExclusiveC14nForTimeStampsAlgorithmsProvider() {
        }

        @Override
        public Algorithm getCanonicalizationAlgorithmForTimeStampProperties() {
            return new ExclusiveCanonicalXMLWithoutComments(new String[]{"ds", "xades"});
        }

        @Override
        public Algorithm getCanonicalizationAlgorithmForSignature() {
            return new ExclusiveCanonicalXMLWithoutComments(new String[0]);
        }
    }

    static class TestTimeStampTokenProvider
    extends HttpTimeStampTokenProvider {
        @Inject
        public TestTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider) {
            super(messageDigestProvider, new TSAHttpData("http://tsa.starfieldtech.com"));
        }
    }
}

