/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import xades4j.XAdES4jException;
import xades4j.production.Init;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertiesDataObjectsGenerator;
import xades4j.production.XadesSignatureFormatExtender;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.data.SigAndDataObjsPropertiesData;
import xades4j.utils.DOMHelper;
import xades4j.xml.marshalling.UnsignedPropertiesMarshaller;

class XadesSignatureFormatExtenderImpl
implements XadesSignatureFormatExtender {
    private final PropertiesDataObjectsGenerator propsDataObjectsGenerator;
    private final UnsignedPropertiesMarshaller unsignedPropsMarshaller;

    static {
        Init.initXMLSec();
    }

    @Inject
    XadesSignatureFormatExtenderImpl(PropertiesDataObjectsGenerator propsDataObjectsGenerator, UnsignedPropertiesMarshaller unsignedPropsMarshaller) {
        this.propsDataObjectsGenerator = propsDataObjectsGenerator;
        this.unsignedPropsMarshaller = unsignedPropsMarshaller;
    }

    @Override
    public void enrichSignature(XMLSignature sig, UnsignedProperties props) throws XAdES4jException {
        if (props.isEmpty()) {
            return;
        }
        if (!props.getDataObjProps().isEmpty()) {
            throw new NullPointerException();
        }
        Element qualifProps = DOMHelper.getFirstDescendant(sig.getElement(), "http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties");
        if (qualifProps == null) {
            throw new IllegalArgumentException("Couldn't find XAdES QualifyingProperties");
        }
        Element signedProps = DOMHelper.getFirstChildElement(qualifProps);
        if (signedProps != null && signedProps.getLocalName().equals("SignedProperties") && signedProps.getNamespaceURI().equals("http://uri.etsi.org/01903/v1.3.2#")) {
            DOMHelper.useIdAsXmlId(signedProps);
        }
        SigAndDataObjsPropertiesData propsData = this.propsDataObjectsGenerator.generateUnsignedPropertiesData(props, new PropertiesDataGenerationContext(sig));
        if (sig.getDocument().lookupPrefix("http://uri.etsi.org/01903/v1.4.1#") == null) {
            qualifProps.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        }
        this.unsignedPropsMarshaller.marshal(propsData, qualifProps);
    }
}

